/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.scijava.annotations.EclipseHelper;
import org.scijava.annotations.IndexItem;
import org.scijava.annotations.IndexReader;

public class Index<A extends Annotation>
implements Iterable<IndexItem<A>> {
    static final String INDEX_PREFIX = "META-INF/json/";
    private static final String LEGACY_INDEX_PREFIX = "META-INF/annotations/";
    private final Class<A> annotation;
    private final ClassLoader loader;

    public static <A extends Annotation> Index<A> load(Class<A> annotation) {
        return Index.load(annotation, Thread.currentThread().getContextClassLoader());
    }

    public static <A extends Annotation> Index<A> load(Class<A> annotation, ClassLoader loader) {
        EclipseHelper.updateAnnotationIndex(loader);
        return new Index<A>(annotation, loader);
    }

    private Index(Class<A> annotation, ClassLoader loader) {
        this.annotation = annotation;
        this.loader = loader;
    }

    @Override
    public Iterator<IndexItem<A>> iterator() {
        return new IndexItemIterator(this.annotation);
    }

    private class IndexItemIterator
    implements Iterator<IndexItem<A>> {
        private Enumeration<URL> urls;
        private IndexReader indexReader;
        private IndexItem<A> next;
        private Set<URL> seen = new HashSet<URL>();
        private Map<String, URL> legacyURLs;

        public IndexItemIterator(Class<A> annotation) {
            try {
                this.legacyURLs = new LinkedHashMap<String, URL>();
                Enumeration<URL> legacy = Index.this.loader.getResources(Index.LEGACY_INDEX_PREFIX + annotation.getName());
                int legacySuffixLength = Index.LEGACY_INDEX_PREFIX.length() + annotation.getName().length();
                while (legacy.hasMoreElements()) {
                    URL url = legacy.nextElement();
                    String string = url.toString();
                    String key = string.substring(0, string.length() - legacySuffixLength) + Index.INDEX_PREFIX + annotation.getName();
                    this.legacyURLs.put(key, url);
                }
                if (this.legacyURLs.isEmpty()) {
                    this.legacyURLs = null;
                }
                this.urls = Index.this.loader.getResources(Index.INDEX_PREFIX + annotation.getName());
                this.readNext();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void readNext() throws IOException {
            while (true) {
                Map map;
                if (this.indexReader == null) {
                    this.indexReader = this.getNextReader();
                    if (this.indexReader == null) {
                        this.urls = null;
                        this.next = null;
                        return;
                    }
                }
                if ((map = (Map)this.indexReader.next()) != null) {
                    String className = (String)map.get("class");
                    Map values = (Map)map.get("values");
                    this.next = new IndexItem(Index.this.annotation, Index.this.loader, className, values);
                    return;
                }
                this.indexReader.close();
                this.indexReader = null;
            }
        }

        private IndexReader getNextReader() throws IOException {
            if (this.urls == null) {
                return null;
            }
            while (this.urls.hasMoreElements()) {
                URL url = this.urls.nextElement();
                if (this.seen.contains(url)) continue;
                if (this.legacyURLs != null) {
                    this.legacyURLs.remove(url.toString());
                }
                this.seen.add(url);
                return new IndexReader(url.openStream());
            }
            if (this.legacyURLs != null && !this.legacyURLs.isEmpty()) {
                Map.Entry<String, URL> entry = this.legacyURLs.entrySet().iterator().next();
                this.legacyURLs.remove(entry.getKey());
                return IndexReader.getLegacyReader(entry.getValue().openStream());
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public IndexItem<A> next() {
            IndexItem result = this.next;
            try {
                this.readNext();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.next = null;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

