/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import org.scijava.Context;
import org.scijava.Contextual;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.NullContextException;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.module.AbstractModuleInfo;
import org.scijava.module.DefaultMutableModuleItem;
import org.scijava.module.ModuleException;
import org.scijava.parse.ParseService;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptModule;
import org.scijava.script.ScriptService;
import org.scijava.util.DigestUtils;
import org.scijava.util.FileUtils;

public class ScriptInfo
extends AbstractModuleInfo
implements Contextual {
    private static final int PARAM_CHAR_MAX = 655360;
    private final String path;
    private final String script;
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private ParseService parser;
    @Parameter
    private ConvertService convertService;
    private boolean returnValueDeclared;

    public ScriptInfo(Context context, File file) {
        this(context, file.getPath());
    }

    public ScriptInfo(Context context, String path) {
        this(context, path, null);
    }

    public ScriptInfo(Context context, String path, Reader reader) {
        this.setContext(context);
        this.path = path;
        String script = null;
        if (reader != null) {
            try {
                script = ScriptInfo.getReaderContentsAsString(reader);
            }
            catch (IOException exc) {
                this.log.error("Error reading script: " + path, exc);
            }
        }
        this.script = script;
    }

    public String getPath() {
        return this.path;
    }

    public BufferedReader getReader() {
        if (this.script == null) {
            return null;
        }
        return new BufferedReader(new StringReader(this.script), 655360);
    }

    @Override
    public void parseParameters() {
        this.clearParameters();
        this.returnValueDeclared = false;
        try {
            String line;
            BufferedReader in = this.script == null ? new BufferedReader(new FileReader(this.getPath())) : this.getReader();
            while ((line = in.readLine()) != null) {
                if (line.matches("^[^\\w]*@.*")) {
                    int at = line.indexOf(64);
                    this.parseParam(line.substring(at + 1));
                    continue;
                }
                if (!line.matches(".*\\w.*")) continue;
                break;
            }
            in.close();
            if (!this.returnValueDeclared) {
                this.addReturnValue();
            }
        }
        catch (IOException exc) {
            this.log.error("Error reading script: " + this.path, exc);
        }
        catch (ScriptException exc) {
            this.log.error("Invalid parameter syntax for script: " + this.path, exc);
        }
    }

    public boolean isReturnValueDeclared() {
        return this.returnValueDeclared;
    }

    @Override
    public String getDelegateClassName() {
        return ScriptModule.class.getName();
    }

    @Override
    public Class<?> loadDelegateClass() {
        return ScriptModule.class;
    }

    @Override
    public ScriptModule createModule() throws ModuleException {
        return new ScriptModule(this);
    }

    @Override
    public Context context() {
        if (this.context == null) {
            throw new NullContextException();
        }
        return this.context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        context.inject(this);
    }

    @Override
    public String getIdentifier() {
        return "script:" + this.path;
    }

    @Override
    public String getLocation() {
        return new File(this.path).toURI().normalize().toString();
    }

    @Override
    public String getVersion() {
        File file = new File(this.path);
        if (!file.exists()) {
            return null;
        }
        Date lastModified = FileUtils.getModifiedTime(file);
        String datestamp = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(lastModified);
        try {
            String hash = DigestUtils.bestHex(FileUtils.readFile(file));
            return datestamp + "-" + hash;
        }
        catch (IOException exc) {
            this.log.error(exc);
            return datestamp;
        }
    }

    private void parseParam(String param) throws ScriptException {
        int lParen = param.indexOf("(");
        int rParen = param.lastIndexOf(")");
        if (rParen < lParen) {
            throw new ScriptException("Invalid parameter: " + param);
        }
        if (lParen < 0) {
            this.parseParam(param, this.parseAttrs("()"));
        } else {
            String cutParam = param.substring(0, lParen) + param.substring(rParen + 1);
            String attrs = param.substring(lParen + 1, rParen);
            this.parseParam(cutParam, this.parseAttrs(attrs));
        }
    }

    private void parseParam(String param, Map<String, Object> attrs) throws ScriptException {
        String varName;
        String typeName;
        String[] tokens = param.trim().split("[ \t\n]+");
        this.checkValid(tokens.length >= 1, param);
        if (this.isIOType(tokens[0])) {
            this.checkValid(tokens.length >= 3, param);
            attrs.put("type", tokens[0]);
            typeName = tokens[1];
            varName = tokens[2];
        } else {
            this.checkValid(tokens.length >= 2, param);
            typeName = tokens[0];
            varName = tokens[1];
        }
        Class<?> type = this.scriptService.lookupClass(typeName);
        this.addItem(varName, type, attrs);
        if ("result".equals(varName)) {
            this.returnValueDeclared = true;
        }
    }

    private Map<String, Object> parseAttrs(String attrs) {
        return this.parser.parse(attrs).asMap();
    }

    private boolean isIOType(String token) {
        return this.convertService.convert((Object)token, ItemIO.class) != null;
    }

    private void checkValid(boolean valid, String param) throws ScriptException {
        if (!valid) {
            throw new ScriptException("Invalid parameter: " + param);
        }
    }

    private void addReturnValue() throws ScriptException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("type", "OUTPUT");
        this.addItem("result", Object.class, attrs);
    }

    private <T> void addItem(String name, Class<T> type, Map<String, Object> attrs) {
        DefaultMutableModuleItem<T> item = new DefaultMutableModuleItem<T>(this, name, type);
        for (String key : attrs.keySet()) {
            Object value = attrs.get(key);
            this.assignAttribute(item, key, value);
        }
        if (item.isInput()) {
            this.registerInput(item);
        }
        if (item.isOutput()) {
            this.registerOutput(item);
        }
    }

    private <T> void assignAttribute(DefaultMutableModuleItem<T> item, String k, Object v) {
        if (this.is(k, "callback")) {
            item.setCallback(this.as(v, String.class));
        } else if (this.is(k, "choices")) {
            item.setChoices(this.asList(v, item.getType()));
        } else if (this.is(k, "columns")) {
            item.setColumnCount(this.as(v, Integer.TYPE));
        } else if (this.is(k, "description")) {
            item.setDescription(this.as(v, String.class));
        } else if (this.is(k, "initializer")) {
            item.setInitializer(this.as(v, String.class));
        } else if (this.is(k, "type")) {
            item.setIOType(this.as(v, ItemIO.class));
        } else if (this.is(k, "label")) {
            item.setLabel(this.as(v, String.class));
        } else if (this.is(k, "max")) {
            item.setMaximumValue(this.as(v, item.getType()));
        } else if (this.is(k, "min")) {
            item.setMinimumValue(this.as(v, item.getType()));
        } else if (this.is(k, "name")) {
            item.setName(this.as(v, String.class));
        } else if (this.is(k, "persist")) {
            item.setPersisted(this.as(v, Boolean.TYPE));
        } else if (this.is(k, "persistKey")) {
            item.setPersistKey(this.as(v, String.class));
        } else if (this.is(k, "required")) {
            item.setRequired(this.as(v, Boolean.TYPE));
        } else if (this.is(k, "softMax")) {
            item.setSoftMaximum(this.as(v, item.getType()));
        } else if (this.is(k, "softMin")) {
            item.setSoftMinimum(this.as(v, item.getType()));
        } else if (this.is(k, "stepSize")) {
            item.setStepSize(this.as(v, Double.TYPE));
        } else if (this.is(k, "style")) {
            item.setWidgetStyle(this.as(v, String.class));
        } else if (this.is(k, "visibility")) {
            item.setVisibility(this.as(v, ItemVisibility.class));
        } else if (this.is(k, "value")) {
            item.setDefaultValue(this.as(v, item.getType()));
        } else {
            item.set(k, v.toString());
        }
    }

    private boolean is(String key, String desired) {
        return desired.equalsIgnoreCase(key);
    }

    private <T> T as(Object v, Class<T> type) {
        return this.convertService.convert(v, type);
    }

    private <T> List<T> asList(Object v, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        List list = this.as(v, List.class);
        for (Object item : list) {
            result.add(this.as(item, type));
        }
        return result;
    }

    private static String getReaderContentsAsString(Reader reader) throws IOException, NullPointerException {
        int read;
        char[] buffer = new char[8192];
        StringBuilder builder = new StringBuilder();
        while ((read = reader.read(buffer)) != -1) {
            builder.append(buffer, 0, read);
        }
        return builder.toString();
    }
}

