/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.text;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.scijava.plugin.AbstractHandlerService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.service.Service;
import org.scijava.text.TextFormat;
import org.scijava.text.TextService;

@Plugin(type=Service.class)
public final class DefaultTextService
extends AbstractHandlerService<File, TextFormat>
implements TextService {
    @Parameter
    private PluginService pluginService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String open(File file) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.defaultCharset().decode(bb).toString();
            return string;
        }
    }

    @Override
    public String asHTML(File file) throws IOException {
        TextFormat format = (TextFormat)this.getHandler(file);
        if (format == null) {
            return null;
        }
        return "<html><body>" + format.asHTML(this.open(file)) + "</body></html>";
    }

    @Override
    public Class<TextFormat> getPluginType() {
        return TextFormat.class;
    }

    @Override
    public Class<File> getType() {
        return File.class;
    }
}

