/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.widget;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.ItemVisibility;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.module.MethodCallException;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.thread.ThreadService;
import org.scijava.util.ClassUtils;
import org.scijava.util.ConversionUtils;
import org.scijava.util.NumberUtils;
import org.scijava.widget.InputPanel;
import org.scijava.widget.WidgetModel;

public class DefaultWidgetModel
extends AbstractContextual
implements WidgetModel {
    private final InputPanel<?, ?> inputPanel;
    private final Module module;
    private final ModuleItem<?> item;
    private final List<?> objectPool;
    private final Map<Object, Object> convertedObjects;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private ConvertService convertService;
    @Parameter
    private ModuleService moduleService;
    @Parameter(required=false)
    private LogService log;
    private boolean initialized;

    public DefaultWidgetModel(Context context, InputPanel<?, ?> inputPanel, Module module, ModuleItem<?> item, List<?> objectPool) {
        this.setContext(context);
        this.inputPanel = inputPanel;
        this.module = module;
        this.item = item;
        this.objectPool = objectPool;
        this.convertedObjects = new WeakHashMap<Object, Object>();
        if (item.getValue(module) == null) {
            this.setValue(this.moduleService.getDefaultValue(item));
        }
    }

    @Override
    public InputPanel<?, ?> getPanel() {
        return this.inputPanel;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public ModuleItem<?> getItem() {
        return this.item;
    }

    @Override
    public List<?> getObjectPool() {
        return this.objectPool;
    }

    @Override
    public String getWidgetLabel() {
        String label = this.item.getLabel();
        if (label != null && !label.isEmpty()) {
            return label;
        }
        String name = this.item.getName();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    @Override
    public boolean isStyle(String style) {
        String widgetStyle = this.getItem().getWidgetStyle();
        if (widgetStyle == null) {
            return style == null;
        }
        for (String s : widgetStyle.split(",")) {
            if (!s.equals(style)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getValue() {
        Object value = this.item.getValue(this.module);
        if (this.isMultipleChoice()) {
            return this.ensureValidChoice(value);
        }
        if (this.getObjectPool().size() > 0) {
            return this.ensureValidObject(value);
        }
        return value;
    }

    @Override
    public void setValue(Object value) {
        String name = this.item.getName();
        if (Objects.equals(this.item.getValue(this.module), value)) {
            return;
        }
        Object convertedInput = this.convertedObjects.get(value);
        if (convertedInput != null && Objects.equals(this.item.getValue(this.module), convertedInput)) {
            return;
        }
        convertedInput = this.convertService.convert(value, this.item.getType());
        if (convertedInput != value) {
            this.convertedObjects.put(value, convertedInput);
        }
        this.module.setInput(name, convertedInput);
        if (this.initialized) {
            this.threadService.run(new Runnable(){

                @Override
                public void run() {
                    DefaultWidgetModel.this.callback();
                    DefaultWidgetModel.this.inputPanel.refresh();
                    DefaultWidgetModel.this.module.preview();
                }
            });
        }
    }

    @Override
    public void callback() {
        block2: {
            try {
                this.item.callback(this.module);
            }
            catch (MethodCallException exc) {
                if (this.log == null) break block2;
                this.log.error(exc);
            }
        }
    }

    @Override
    public Number getMin() {
        Number min = this.toNumber(this.item.getMinimumValue());
        if (min != null) {
            return min;
        }
        return NumberUtils.getMinimumNumber(this.item.getType());
    }

    @Override
    public Number getMax() {
        Number max = this.toNumber(this.item.getMaximumValue());
        if (max != null) {
            return max;
        }
        return NumberUtils.getMaximumNumber(this.item.getType());
    }

    @Override
    public Number getSoftMin() {
        Number softMin = this.toNumber(this.item.getSoftMinimum());
        if (softMin != null) {
            return softMin;
        }
        return this.getMin();
    }

    @Override
    public Number getSoftMax() {
        Number softMax = this.toNumber(this.item.getSoftMaximum());
        if (softMax != null) {
            return softMax;
        }
        return this.getMax();
    }

    @Override
    public Number getStepSize() {
        Number stepSize = this.toNumber(this.item.getStepSize());
        if (stepSize != null) {
            return stepSize;
        }
        return NumberUtils.toNumber("1", this.item.getType());
    }

    @Override
    public String[] getChoices() {
        List<?> choicesList = this.item.getChoices();
        String[] choices = new String[choicesList.size()];
        for (int i = 0; i < choices.length; ++i) {
            choices[i] = choicesList.get(i).toString();
        }
        return choices;
    }

    @Override
    public String getText() {
        Object value = this.getValue();
        if (value == null) {
            return "";
        }
        String text = value.toString();
        if (text.equals("\u0000")) {
            return "";
        }
        return text;
    }

    @Override
    public boolean isMessage() {
        return this.getItem().getVisibility() == ItemVisibility.MESSAGE;
    }

    @Override
    public boolean isText() {
        return ClassUtils.isText(this.getItem().getType());
    }

    @Override
    public boolean isCharacter() {
        return ClassUtils.isCharacter(this.getItem().getType());
    }

    @Override
    public boolean isNumber() {
        return ClassUtils.isNumber(this.getItem().getType());
    }

    @Override
    public boolean isBoolean() {
        return ClassUtils.isBoolean(this.getItem().getType());
    }

    @Override
    public boolean isMultipleChoice() {
        List<?> choices = this.item.getChoices();
        return choices != null && !choices.isEmpty();
    }

    @Override
    public boolean isType(Class<?> type) {
        return type.isAssignableFrom(this.getItem().getType());
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    private Object ensureValidChoice(Object value) {
        return this.ensureValid(value, Arrays.asList(this.getChoices()));
    }

    private Object ensureValidObject(Object value) {
        return this.ensureValid(value, this.getObjectPool());
    }

    private Object ensureValid(Object value, List<?> list) {
        for (Object o : list) {
            if (o.equals(value)) {
                return value;
            }
            Object convertedValue = this.convertedObjects.get(o);
            if (convertedValue == null || !value.equals(convertedValue)) continue;
            return convertedValue;
        }
        Object validValue = list.get(0);
        this.setValue(validValue);
        return validValue;
    }

    private Number toNumber(Object value) {
        Class<?> type = this.item.getType();
        Class<?> saneType = ConversionUtils.getNonprimitiveType(type);
        return NumberUtils.toNumber(value, saneType);
    }
}

