/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.io.handle.AbstractHigherOrderHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.BytesLocation;
import org.scijava.io.location.Location;

public class DataHandleEdgeCaseTests {
    private static final byte[] BYTES = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, -128, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 125, 127, -127, -125, -3, 104, 101};

    @Test
    public void testFindStringsOnUnknonwLengthHandle() throws IOException {
        Context ctx = new Context();
        DataHandleService dhs = (DataHandleService)ctx.getService(DataHandleService.class);
        DummyHandle dummy = new DummyHandle((DataHandle<Location>)((DataHandle)dhs.create((Object)new BytesLocation(BYTES))));
        Assert.assertEquals((Object)"Hello,", (Object)dummy.findString(new String[]{","}));
        Assert.assertEquals((Object)" world\n", (Object)dummy.findString(new String[]{"\n"}));
        dummy.seek(41L);
        Assert.assertEquals((Object)"he", (Object)dummy.findString(new String[]{"\n"}));
        dummy.seek(16L);
        Assert.assertArrayEquals((byte[])Arrays.copyOfRange(BYTES, 16, 23), (byte[])dummy.readCString().getBytes());
        dummy.seek(42L);
        Assert.assertNull((Object)dummy.readCString());
    }

    private class DummyHandle
    extends AbstractHigherOrderHandle<Location> {
        public DummyHandle(DataHandle<Location> handle) {
            super(handle);
        }

        public long length() throws IOException {
            return -1L;
        }

        public long offset() throws IOException {
            return this.handle().offset();
        }

        public void seek(long pos) throws IOException {
            this.handle().seek(pos);
        }

        public void setLength(long length) throws IOException {
            this.handle().setLength(length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.handle().read(b, off, len);
        }

        public byte readByte() throws IOException {
            return this.handle().readByte();
        }

        public void write(int b) throws IOException {
            this.handle().write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.handle().write(b, off, len);
        }

        protected void cleanup() throws IOException {
        }
    }
}

