/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.IntArray;
import org.scijava.util.PrimitiveArray;
import org.scijava.util.PrimitiveArrayTest;

public class IntArrayTest
extends PrimitiveArrayTest {
    @Test
    public void testConstructorNoArgs() {
        IntArray array = new IntArray();
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)((int[])array.copyArray()).length);
    }

    @Test
    public void testConstructorSize() {
        int size = 24;
        IntArray array = new IntArray(24);
        Assert.assertEquals((long)24L, (long)array.size());
        Assert.assertEquals((long)24L, (long)((int[])array.copyArray()).length);
    }

    @Test
    public void testConstructorArray() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
        Assert.assertEquals((long)raw.length, (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertArrayEquals((int[])raw, (int[])((int[])array.copyArray()));
    }

    @Test
    public void testAddValue() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        boolean e6 = true;
        int e7 = 2;
        array.addValue(1);
        array.addValue(2);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertEquals((long)1L, (long)array.getValue(5));
        Assert.assertEquals((long)2L, (long)array.getValue(6));
    }

    public void testRemoveValue() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeValue(raw[0]);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.removeValue(raw[2]);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.removeValue(raw[4]);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    public void testGetValue() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
    }

    @Test
    public void testSetValue() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        int e0 = 7;
        boolean e2 = true;
        int e4 = 2;
        array.setValue(0, 7);
        array.setValue(2, 1);
        array.setValue(4, 2);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((long)7L, (long)array.getValue(0));
        Assert.assertEquals((long)raw[1], (long)array.getValue(1));
        Assert.assertEquals((long)1L, (long)array.getValue(2));
        Assert.assertEquals((long)raw[3], (long)array.getValue(3));
        Assert.assertEquals((long)2L, (long)array.getValue(4));
    }

    @Test
    public void testAddValueIndex() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        int e0 = 7;
        boolean e4 = true;
        int e7 = 2;
        array.addValue(0, 7);
        array.addValue(4, 1);
        array.addValue(7, 2);
        Assert.assertEquals((long)(raw.length + 3), (long)array.size());
        Assert.assertEquals((long)7L, (long)array.getValue(0));
        Assert.assertEquals((long)raw[0], (long)array.getValue(1));
        Assert.assertEquals((long)raw[1], (long)array.getValue(2));
        Assert.assertEquals((long)raw[2], (long)array.getValue(3));
        Assert.assertEquals((long)1L, (long)array.getValue(4));
        Assert.assertEquals((long)raw[3], (long)array.getValue(5));
        Assert.assertEquals((long)raw[4], (long)array.getValue(6));
        Assert.assertEquals((long)2L, (long)array.getValue(7));
    }

    public void testRemoveIndex() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove(0);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove(2);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove(4);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    @Test
    public void testIndexOf() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf(-1));
        Assert.assertEquals((long)-1L, (long)array.indexOf(0));
        Assert.assertEquals((long)-1L, (long)array.indexOf(1));
        Assert.assertEquals((long)-1L, (long)array.indexOf(Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)array.indexOf(Integer.MIN_VALUE));
    }

    @Test
    public void testLastIndexOf() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(-1));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(0));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(1));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(Integer.MIN_VALUE));
    }

    @Test
    public void testContains() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains(raw[i]));
        }
        Assert.assertFalse((boolean)array.contains(-1));
        Assert.assertFalse((boolean)array.contains(0));
        Assert.assertFalse((boolean)array.contains(1));
        Assert.assertFalse((boolean)array.contains(Integer.MAX_VALUE));
        Assert.assertFalse((boolean)array.contains(Integer.MIN_VALUE));
    }

    @Test
    public void testSetArray() {
        IntArray array = new IntArray();
        int[] raw = new int[]{1, 2, 3, 5, 8, 13, 21};
        array.setArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
    }

    @Test
    public void testInsert() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        this.testInsert((PrimitiveArray<?, ?>)new IntArray(raw));
    }

    @Test
    public void testDelete() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        this.testDelete((PrimitiveArray<?, ?>)new IntArray(raw));
    }

    @Test
    public void testGet() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.get(i).intValue());
        }
    }

    @Test
    public void testSet() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        Integer e0 = 7;
        Integer e2 = 1;
        Integer e4 = 2;
        array.set(0, e0);
        array.set(2, e2);
        array.set(4, e4);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((Object)e0, (Object)array.get(0));
        Assert.assertEquals((long)raw[1], (long)array.getValue(1));
        Assert.assertEquals((Object)e2, (Object)array.get(2));
        Assert.assertEquals((long)raw[3], (long)array.getValue(3));
        Assert.assertEquals((Object)e4, (Object)array.get(4));
    }

    @Test
    public void testAdd() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        Integer e6 = 1;
        Integer e7 = 2;
        array.add((Object)e6);
        array.add((Object)e7);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertEquals((Object)e6, (Object)array.get(5));
        Assert.assertEquals((Object)e7, (Object)array.get(6));
    }

    @Test
    public void testIndexOfBoxed() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf((Object)new Integer(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Integer(-1)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Integer(0)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Integer(1)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Integer(Integer.MAX_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Integer(Integer.MIN_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.indexOf(null));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)"Not an int"));
    }

    @Test
    public void testLastIndexOfBoxed() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf((Object)new Integer(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Integer(-1)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Integer(0)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Integer(1)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Integer(Integer.MAX_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Integer(Integer.MIN_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(null));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)"Not an int"));
    }

    @Test
    public void testContainsBoxed() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains((Object)new Integer(raw[i])));
        }
        Assert.assertFalse((boolean)array.contains((Object)new Integer(-1)));
        Assert.assertFalse((boolean)array.contains((Object)new Integer(0)));
        Assert.assertFalse((boolean)array.contains((Object)new Integer(1)));
        Assert.assertFalse((boolean)array.contains((Object)new Integer(Integer.MAX_VALUE)));
        Assert.assertFalse((boolean)array.contains((Object)new Integer(Integer.MIN_VALUE)));
        Assert.assertFalse((boolean)array.contains(null));
        Assert.assertFalse((boolean)array.contains((Object)"Not an int"));
    }

    @Test
    public void testRemove() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove((Object)new Integer(raw[0]));
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove((Object)new Integer(raw[2]));
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove((Object)new Integer(raw[4]));
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    @Test
    public void testContainsAll() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        ArrayList<Integer> list = new ArrayList<Integer>();
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(13);
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(1);
        Assert.assertFalse((boolean)array.containsAll(list));
        IntArray yes = new IntArray(new int[]{3, 8, 21});
        Assert.assertTrue((boolean)array.containsAll((Collection)yes));
        IntArray no = new IntArray(new int[]{5, 13, 1});
        Assert.assertFalse((boolean)array.containsAll((Collection)no));
    }

    @Test
    public void testAddAll() {
        int i;
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        int[] add = new int[]{1, 7};
        IntArray toAdd = new IntArray((int[])add.clone());
        int index = 3;
        array.addAll(3, (Collection)toAdd);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((long)raw[i], (long)array.getValue(i));
        }
        for (i = 3; i < 3 + add.length; ++i) {
            Assert.assertEquals((long)add[i - 3], (long)array.getValue(i));
        }
        for (i = 3 + add.length; i < raw.length + add.length; ++i) {
            Assert.assertEquals((long)raw[i - add.length], (long)array.getValue(i));
        }
    }

    @Test
    public void testRemoveAll() {
        int[] raw = new int[]{3, 5, 8, 13, 21};
        IntArray array = new IntArray((int[])raw.clone());
        IntArray toRemove = new IntArray(new int[]{3, 8, 21});
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeAll((Collection)toRemove);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }
}

