/*
 * #%L
 * SciJava Common shared library for SciJava software.
 * %%
 * Copyright (C) 2009 - 2022 SciJava developers.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

package org.scijava;

import java.io.Serializable;

/**
 * An object which can express itself by some unique string.
 * <p>
 * Two objects that produce the same identifier string can be considered
 * equivalent by some metric. The main use case for these identifiers is as a
 * weak form of long-term serialization:
 * </p>
 * <ol>
 * <li>An object's identifier is saved to long-term storage such as disk.</li>
 * <li>Later, in a new JVM, the identifier is retrieved from disk.</li>
 * <li>An existing index of objects is queried to find the object (if any) whose
 * identifier matches the retrieved one.</li>
 * </ol>
 * <p>
 * In this way, objects themselves do not need to be {@link Serializable}, nor
 * do multiple potentially equivalent objects need to be synthesized and then
 * compared using {@link Object#equals}.
 * </p>
 * 
 * @author Curtis Rueden
 */
public interface Identifiable {

	/** Gets a string intended to function as an identifier for the object. */
	String getIdentifier();

}
