/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.convert.StringToArrayConverter;
import org.scijava.parse.ParseService;

public class StringToArrayConverterTest {
    private final StringToArrayConverter converter = new StringToArrayConverter();
    private ConvertService convertService;
    private Context context;

    @Before
    public void setUp() {
        this.context = new Context(new Class[]{ParseService.class, ConvertService.class});
        this.context.inject((Object)this.converter);
        this.convertService = (ConvertService)this.context.getService(ConvertService.class);
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void testArrayConversion() {
        List<Class> classes = Arrays.asList(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class);
        String s = "{0, 1, 2}";
        for (Class c : classes) {
            Class<?> arrayClass = Array.newInstance(c, 0).getClass();
            Assert.assertTrue((boolean)this.converter.canConvert((Object)s, arrayClass));
            Object converted = this.converter.convert((Object)s, arrayClass);
            Assert.assertEquals(arrayClass, converted.getClass());
            for (int i = 0; i < 3; ++i) {
                Object expected = this.convertService.convert((Object)i, c);
                Assert.assertEquals((Object)expected, (Object)Array.get(converted, i));
            }
        }
    }

    @Test
    public void test2DArrayConversion() {
        String s = "{{0, 1}, {2, 3}}";
        Assert.assertTrue((boolean)this.converter.canConvert((Object)s, byte[][].class));
        byte[][] actual = (byte[][])this.converter.convert((Object)s, byte[][].class);
        Assert.assertEquals((long)0L, (long)actual[0][0]);
        Assert.assertEquals((long)1L, (long)actual[0][1]);
        Assert.assertEquals((long)2L, (long)actual[1][0]);
        Assert.assertEquals((long)3L, (long)actual[1][1]);
    }

    @Test
    public void test3DArrayConversion() {
        String s = "{{{0, 1}, {1, 2}},{{1, 2}, {2, 3}}}";
        Assert.assertTrue((boolean)this.converter.canConvert((Object)s, byte[][][].class));
        byte[][][] actual = (byte[][][])this.converter.convert((Object)s, byte[][][].class);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    Assert.assertEquals((long)(i + j + k), (long)actual[i][j][k]);
                }
            }
        }
    }

    @Test
    public void testEmptyArrayConversion() {
        String s = "{}";
        Assert.assertTrue((boolean)this.converter.canConvert((Object)s, byte[].class));
        byte[] actual = (byte[])this.converter.convert((Object)s, byte[].class);
        Assert.assertEquals((long)0L, (long)actual.length);
    }

    @Test
    public void testInconvertibleArrayType() {
        String s = "{ConverterA}";
        Assert.assertFalse((boolean)this.converter.canConvert((Object)s, Converter[].class));
    }

    @Test
    public void testStringArrayConversion() {
        Object[] expected = new String[]{"{foo", "bar}", "ha\nha", "foo,bar", "lol\"lol", "foo\\\"bar"};
        String converted = (String)this.convertService.convert((Object)expected, String.class);
        Assert.assertEquals((Object)"{\"{foo\", \"bar}\", \"ha\nha\", \"foo,bar\", \"lol\\\"lol\", \"foo\\\\\\\"bar\"}", (Object)converted);
        Object[] actual = (String[])this.convertService.convert((Object)converted, String[].class);
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testCharacterArrayConversion() {
        Object[] expected = new Character[]{Character.valueOf('s'), Character.valueOf('\n'), Character.valueOf(','), Character.valueOf('{'), Character.valueOf('}')};
        String converted = (String)this.convertService.convert((Object)expected, String.class);
        Assert.assertEquals((Object)"{\"s\", \"\n\", \",\", \"{\", \"}\"}", (Object)converted);
        Object[] actual = (Character[])this.convertService.convert((Object)converted, Character[].class);
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }
}

