/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.text;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.plugin.Plugin;
import org.scijava.text.AbstractTextFormat;
import org.scijava.text.TextFormat;
import org.scijava.text.TextService;

public class TextServiceTest {
    private Context ctx;
    private TextService textService;

    @Before
    public void setUp() {
        this.ctx = new Context(new Class[]{TextService.class});
        this.textService = (TextService)this.ctx.service(TextService.class);
    }

    @After
    public void tearDown() {
        this.ctx.dispose();
    }

    @Test
    public void testGetHandler() {
        TextFormat fooHandler = this.textService.getHandler(new File("data.foo"));
        Assert.assertNotNull((Object)fooHandler);
        Assert.assertEquals(FooTextFormat.class, fooHandler.getClass());
        System.out.println(fooHandler);
        TextFormat barHandler = this.textService.getHandler(new File("data.bar"));
        Assert.assertNull((Object)barHandler);
    }

    @Plugin(type=TextFormat.class)
    public static class FooTextFormat
    extends AbstractTextFormat {
        public List<String> getExtensions() {
            return Arrays.asList("foo");
        }

        public String asHTML(String text) {
            return "[FOO]" + text + "[/FOO]";
        }
    }
}

