/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.input;

import org.junit.Assert;
import org.junit.Test;
import org.scijava.input.Accelerator;
import org.scijava.input.InputModifiers;
import org.scijava.input.KeyCode;
import org.scijava.util.PlatformUtils;

public class AcceleratorTest {
    @Test
    public void testCreate() {
        this.assertAccelerator("*", KeyCode.ASTERISK, false, false, false, false, false);
        this.assertAccelerator("0", KeyCode.NUM0, false, false, false, false, false);
        this.assertAccelerator("NUMPAD_0", KeyCode.NUMPAD_0, false, false, false, false, false);
        this.assertAccelerator("+", KeyCode.PLUS, false, false, false, false, false);
        this.assertAccelerator("shift minus", KeyCode.MINUS, false, false, false, false, true);
        this.assertAccelerator("ctrl shift +", KeyCode.PLUS, false, false, true, false, true);
        this.assertAccelerator("meta /", KeyCode.SLASH, false, false, false, true, false);
        this.assertAccelerator("alt altGr ctrl meta shift a", KeyCode.A, true, true, true, true, true);
        boolean macos = PlatformUtils.isMac();
        this.assertAccelerator("^Z", KeyCode.Z, false, false, !macos, macos, false);
    }

    private void assertAccelerator(String shortcut, KeyCode keyCode, boolean alt, boolean altGr, boolean ctrl, boolean meta, boolean shift) {
        Accelerator acc = Accelerator.create((String)shortcut);
        Assert.assertEquals((Object)acc.getKeyCode(), (Object)keyCode);
        InputModifiers mods = acc.getModifiers();
        Assert.assertNotNull((Object)mods);
        Assert.assertEquals((Object)alt, (Object)mods.isAltDown());
        Assert.assertEquals((Object)altGr, (Object)mods.isAltGrDown());
        Assert.assertEquals((Object)ctrl, (Object)mods.isCtrlDown());
        Assert.assertEquals((Object)meta, (Object)mods.isMetaDown());
        Assert.assertEquals((Object)shift, (Object)mods.isShiftDown());
        Assert.assertFalse((boolean)mods.isLeftButtonDown());
        Assert.assertFalse((boolean)mods.isMiddleButtonDown());
        Assert.assertFalse((boolean)mods.isRightButtonDown());
    }
}

