/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.platform;

import java.io.IOException;
import java.net.URL;
import org.scijava.log.LogService;
import org.scijava.platform.AbstractPlatform;
import org.scijava.platform.Platform;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Platform.class, name="Default", priority=-10000.0)
public class DefaultPlatform
extends AbstractPlatform {
    @Parameter(required=false)
    private LogService log;

    @Override
    public void open(URL url) throws IOException {
        String[] browsers;
        for (String browser : browsers = new String[]{"xdg-open", "netscape", "firefox", "konqueror", "mozilla", "opera", "epiphany", "lynx"}) {
            try {
                int exitCode = this.getPlatformService().exec(browser, url.toString());
                if (exitCode == 0) {
                    return;
                }
                if (this.log == null) continue;
                this.log.debug("Command '" + browser + "' failed with exit code " + exitCode);
            }
            catch (IOException e) {
                if (this.log == null) continue;
                this.log.debug("Command '" + browser + "' failed", e);
            }
        }
        throw new IOException("Could not open " + url);
    }
}

