/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep.eval;

import java.util.ArrayDeque;
import java.util.LinkedList;
import org.scijava.sjep.ExpressionParser;
import org.scijava.sjep.Function;
import org.scijava.sjep.Operator;
import org.scijava.sjep.Tokens;
import org.scijava.sjep.Verb;
import org.scijava.sjep.eval.AbstractEvaluator;
import org.scijava.sjep.eval.StackEvaluator;

public abstract class AbstractStackEvaluator
extends AbstractEvaluator
implements StackEvaluator {
    private static final String[] ARY = new String[]{"nullary", "unary", "binary", "ternary", "quaternary", "quinary", "senary", "septenary", "octary", "nonary"};

    public AbstractStackEvaluator() {
    }

    public AbstractStackEvaluator(ExpressionParser parser) {
        super(parser);
    }

    @Override
    public Object evaluate(LinkedList<Object> queue) {
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        while (!queue.isEmpty()) {
            Object token = queue.removeFirst();
            Object result = Tokens.isVerb(token) ? this.execute((Verb)token, stack) : token;
            if (result == null) {
                AbstractStackEvaluator.die(token);
            }
            stack.push(result);
        }
        if (stack.size() != 1) {
            throw new IllegalArgumentException("Expected one result but got " + stack.size());
        }
        return stack.pop();
    }

    private static String ary(int arity) {
        return arity < ARY.length ? ARY[arity] : arity + "-ary";
    }

    private static String ary(Verb verb) {
        return AbstractStackEvaluator.ary(verb.getArity());
    }

    private static void die(Object token) {
        StringBuilder message = new StringBuilder("Unsupported");
        if (token instanceof Verb) {
            message.append(" " + AbstractStackEvaluator.ary((Verb)token));
        }
        message.append(" " + AbstractStackEvaluator.type(token) + ": " + token);
        throw new IllegalArgumentException(message.toString());
    }

    private static String type(Object token) {
        if (token instanceof Operator) {
            return "operator";
        }
        if (token instanceof Function) {
            return "function";
        }
        return "token";
    }
}

