/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.scijava.sjep.Function;
import org.scijava.sjep.Literals;
import org.scijava.sjep.Operator;
import org.scijava.sjep.Operators;
import org.scijava.sjep.Position;
import org.scijava.sjep.SyntaxTree;
import org.scijava.sjep.Tokens;
import org.scijava.sjep.Variable;

public class ExpressionParser {
    private final List<Operator> operators;

    public ExpressionParser() {
        this(Operators.standardList());
    }

    public ExpressionParser(Collection<? extends Operator> operators) {
        this.operators = new ArrayList<Operator>(operators);
        Collections.sort(this.operators, new Comparator<Operator>(){

            @Override
            public int compare(Operator o1, Operator o2) {
                int len2;
                String t1 = o1.getToken();
                String t2 = o2.getToken();
                int len1 = t1.length();
                if (len1 > (len2 = t2.length())) {
                    return -1;
                }
                if (len1 < len2) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
        });
    }

    public SyntaxTree parseTree(String expression) {
        return new ParseOperation(expression).parseTree();
    }

    public LinkedList<Object> parsePostfix(String expression) {
        return new ParseOperation(expression).parsePostfix();
    }

    private class ParseOperation {
        private final String expression;
        private final Position pos = new Position();
        private final Deque<Object> stack = new ArrayDeque<Object>();
        private final LinkedList<Object> outputQueue = new LinkedList();
        private boolean infix;

        public ParseOperation(String expression) {
            this.expression = expression;
        }

        public SyntaxTree parseTree() {
            return new SyntaxTree(this.parsePostfix());
        }

        public LinkedList<Object> parsePostfix() {
            while (this.pos.get() < this.expression.length()) {
                this.parseWhitespace();
                Object literal = this.parseLiteral();
                if (literal != null) {
                    this.outputQueue.add(literal);
                    this.infix = true;
                    continue;
                }
                Function func = this.parseFunction();
                if (func != null) {
                    this.stack.push(func);
                    this.infix = false;
                    continue;
                }
                Character separator = this.parseComma();
                if (separator != null) {
                    while (true) {
                        if (this.stack.isEmpty()) {
                            this.pos.die("Misplaced separator or mismatched parentheses");
                        }
                        if (Tokens.isFunction(this.stack.peek())) break;
                        this.outputQueue.add(this.stack.pop());
                    }
                    ((Function)this.stack.peek()).incArity();
                    this.infix = false;
                    continue;
                }
                Character semicolon = this.parseSemicolon();
                if (semicolon != null) {
                    this.flushStack();
                    this.infix = false;
                    continue;
                }
                Operator o1 = this.parseOperator();
                if (o1 != null) {
                    double p1 = o1.getPrecedence();
                    while (!this.stack.isEmpty() && Tokens.isOperator(this.stack.peek())) {
                        Operator o2 = (Operator)this.stack.peek();
                        double p2 = o2.getPrecedence();
                        if (!(o1.isLeftAssociative() && p1 <= p2) && (!o1.isRightAssociative() || !(p1 < p2))) break;
                        this.outputQueue.add(this.stack.pop());
                    }
                    this.stack.push(o1);
                    if (o1.isPrefix() || o1.isInfix()) {
                        this.infix = false;
                        continue;
                    }
                    if (o1.isPostfix()) {
                        this.infix = true;
                        continue;
                    }
                    this.pos.fail("Impenetrable operator '" + o1 + "'");
                    continue;
                }
                Character leftParen = this.parseLeftParen();
                if (leftParen != null) {
                    this.stack.push(leftParen);
                    this.infix = false;
                    continue;
                }
                Character rightParen = this.parseRightParen();
                if (rightParen != null) {
                    while (true) {
                        if (this.stack.isEmpty()) {
                            this.pos.die("Mismatched parentheses");
                        }
                        if (Tokens.isLeftParen(this.stack.peek())) {
                            this.stack.pop();
                            break;
                        }
                        if (Tokens.isFunction(this.stack.peek())) {
                            if (this.infix) {
                                ((Function)this.stack.peek()).incArity();
                            }
                            this.outputQueue.add(this.stack.pop());
                            break;
                        }
                        this.outputQueue.add(this.stack.pop());
                    }
                    this.infix = true;
                    continue;
                }
                Variable variable = this.parseVariable();
                if (variable != null) {
                    this.outputQueue.add(variable);
                    this.infix = true;
                    continue;
                }
                this.pos.die("Invalid character");
            }
            this.flushStack();
            return this.outputQueue;
        }

        public char currentChar() {
            return this.futureChar(0);
        }

        public char futureChar(int offset) {
            return this.pos.ch(this.expression, offset);
        }

        public boolean isPrefixOK() {
            return !this.infix;
        }

        public boolean isPostfixOK() {
            return this.infix;
        }

        public boolean isInfixOK() {
            return this.infix;
        }

        public void parseWhitespace() {
            while (Character.isWhitespace(this.currentChar())) {
                this.pos.inc();
            }
        }

        public Object parseLiteral() {
            if (this.infix) {
                return null;
            }
            return Literals.parseLiteral(this.expression, this.pos);
        }

        public Function parseFunction() {
            int length = this.parseIdentifier();
            if (length == 0) {
                return null;
            }
            int offset = length;
            while (Character.isWhitespace(this.futureChar(offset))) {
                ++offset;
            }
            if (!Tokens.isLeftParen(Character.valueOf(this.futureChar(offset)))) {
                return null;
            }
            String token = this.parseToken(length);
            this.parseWhitespace();
            this.pos.assertThat(Tokens.isLeftParen(this.parseLeftParen()), "Left parenthesis expected after function");
            return new Function(token);
        }

        public Variable parseVariable() {
            int length = this.parseIdentifier();
            if (length == 0) {
                return null;
            }
            return new Variable(this.parseToken(length));
        }

        public int parseIdentifier() {
            char next;
            if (this.infix) {
                return 0;
            }
            if (!Character.isUnicodeIdentifierStart(this.currentChar())) {
                return 0;
            }
            int length = 0;
            while ((next = this.futureChar(length)) != '\u0000' && Character.isUnicodeIdentifierPart(next)) {
                ++length;
            }
            return length;
        }

        public Operator parseOperator() {
            for (Operator operator : ExpressionParser.this.operators) {
                String symbol = operator.getToken();
                if (!this.expression.startsWith(symbol, this.pos.get()) || !(this.isPrefixOK() && operator.isPrefix() || this.isPostfixOK() && operator.isPostfix()) && (!this.isInfixOK() || !operator.isInfix())) continue;
                this.pos.inc(symbol.length());
                return operator;
            }
            return null;
        }

        public Character parseComma() {
            if (!this.infix) {
                return null;
            }
            return this.parseChar(',');
        }

        public Character parseLeftParen() {
            return this.parseChar('(');
        }

        public Character parseRightParen() {
            return this.parseChar(')');
        }

        public Character parseSemicolon() {
            return this.parseChar(';');
        }

        public Character parseChar(char c) {
            if (this.currentChar() == c) {
                this.pos.inc();
                return Character.valueOf(c);
            }
            return null;
        }

        public String parseToken(int length) {
            int offset = this.pos.get();
            String token = this.expression.substring(offset, offset + length);
            this.pos.inc(length);
            return token;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.expression);
            sb.append("\n");
            for (int i = 0; i < this.pos.get(); ++i) {
                sb.append(" ");
            }
            sb.append("^");
            return sb.toString();
        }

        private void flushStack() {
            while (!this.stack.isEmpty()) {
                Object token = this.stack.pop();
                if (Tokens.isParen(token)) {
                    this.pos.die("Mismatched parentheses");
                }
                this.outputQueue.add(token);
            }
        }
    }
}

