/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep.eval;

import java.util.HashMap;
import java.util.Map;
import org.scijava.sjep.ExpressionParser;
import org.scijava.sjep.SyntaxTree;
import org.scijava.sjep.Tokens;
import org.scijava.sjep.Variable;
import org.scijava.sjep.eval.Evaluator;

public abstract class AbstractEvaluator
implements Evaluator {
    private final HashMap<String, Object> vars = new HashMap();
    private final ExpressionParser parser;

    public AbstractEvaluator() {
        this(new ExpressionParser());
    }

    public AbstractEvaluator(ExpressionParser parser) {
        this.parser = parser;
    }

    @Override
    public ExpressionParser getParser() {
        return this.parser;
    }

    @Override
    public Object evaluate(SyntaxTree syntaxTree) {
        return this.evaluate(syntaxTree.postfix());
    }

    @Override
    public Object evaluate(String expression) {
        return this.evaluate(this.parser.parsePostfix(expression));
    }

    @Override
    public Object value(Object token) {
        return Tokens.isVariable(token) ? this.get((Variable)token) : token;
    }

    @Override
    public Object get(Variable v) {
        String name = v.getToken();
        if (this.vars.containsKey(name)) {
            return this.vars.get(name);
        }
        throw new IllegalArgumentException("Unknown variable: " + name);
    }

    @Override
    public void set(Variable v, Object value) {
        this.vars.put(v.getToken(), value);
    }

    @Override
    public void setAll(Map<? extends String, ? extends Object> map) {
        this.vars.putAll(map);
    }
}

