/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.scijava.maven.plugin.SnapshotException;
import org.scijava.maven.plugin.SnapshotFinder;

public class RequireReproducibleBuilds
implements EnforcerRule {
    private boolean failEarly = false;
    private boolean verbose = false;
    private String groupId;
    private String groupIds;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            ArtifactRepository localRepository = (ArtifactRepository)helper.evaluate("${localRepository}");
            MavenProjectBuilder projectBuilder = (MavenProjectBuilder)helper.getComponent(MavenProjectBuilder.class);
            ArrayList ids = new ArrayList();
            if (this.groupId != null) {
                this.addId(ids, this.groupId);
            }
            if (this.groupIds != null) {
                for (String id : this.groupIds.split(",")) {
                    this.addId(ids, id);
                }
            }
            SnapshotFinder fs = new SnapshotFinder(projectBuilder, localRepository, this.failEarly, this.verbose, ids);
            fs.setLog(log);
            fs.checkProject(project);
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException(e.getMessage());
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException(e.getMessage());
        }
        catch (SnapshotException e) {
            throw new EnforcerRuleException(e.getMessage());
        }
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule cachedRule) {
        return false;
    }

    public String getCacheId() {
        return null;
    }

    private void addId(List ids, String groupId) {
        ids.add(groupId);
    }
}

