/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Hints {
    final Set<String> hints;

    public Hints(String ... startingHints) {
        this(Arrays.asList(startingHints));
    }

    private Hints(Collection<String> hints) {
        this.hints = new HashSet<String>(hints);
    }

    public Hints plus(String ... hints) {
        HashSet<String> newHints = new HashSet<String>(this.hints);
        newHints.addAll(Arrays.asList(hints));
        return new Hints(newHints);
    }

    public Hints plus(Hints other) {
        HashSet<String> newHints = new HashSet<String>(this.hints);
        newHints.addAll(other.hints);
        return new Hints(newHints);
    }

    public Hints minus(String ... hints) {
        HashSet<String> newHints = new HashSet<String>(this.hints);
        Arrays.asList(hints).forEach(newHints::remove);
        return new Hints(newHints);
    }

    public boolean contains(String hint) {
        return this.hints.contains(hint);
    }

    public boolean containsNone(String ... hints) {
        return !this.containsAny(hints);
    }

    public boolean containsAny(String ... hints) {
        return Arrays.stream(hints).anyMatch(this::contains);
    }

    public boolean containsAll(String ... hints) {
        return Arrays.stream(hints).allMatch(this::contains);
    }

    public Hints copy() {
        return new Hints(this.hints);
    }

    public int hashCode() {
        return this.hints.hashCode();
    }

    public boolean equals(Object that) {
        if (!(that instanceof Hints)) {
            return false;
        }
        Hints thatHints = (Hints)that;
        return this.hints.equals(thatHints.hints);
    }

    public String toString() {
        return this.hints.toString();
    }
}

