/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.Ops;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.InfoTreeGenerator;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;

public class InfoTreeGeneratorTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.infoTreeGeneration")
    public final Function<Double, Double> foo = in -> in + 1.0;

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new DummyInfoTreeGenerator(), new InfoTreeGeneratorTest()});
    }

    @Test
    public void testMultipleValidInfoTreeGenerators() {
        Function op = ops.op("test.infoTreeGeneration").inType(Double.class).outType(Double.class).function();
        String signature = Ops.signature((Object)op);
        InfoTree infoTree = ops.treeFromSignature(signature);
        Assertions.assertNotNull((Object)infoTree);
    }

    static class DummyInfoTreeGenerator
    implements InfoTreeGenerator {
        DummyInfoTreeGenerator() {
        }

        public InfoTree generate(OpEnvironment env, String signature, Map<String, OpInfo> idMap, Collection<InfoTreeGenerator> generators) {
            return null;
        }

        public boolean canGenerate(String signature) {
            return true;
        }

        public double priority() {
            return -100.0;
        }
    }
}

