/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine;

import java.util.Collections;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Producer;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.ComplexOp;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.types.Nil;

public class InfoTreeTest
extends AbstractTestEnvironment
implements OpCollection {
    private static InfoTree simpleTree;
    private static InfoTree complexTree;
    public static final String S = "this Op is cool";
    @OpField(names="test.infoTree")
    public final Producer<String> foo = () -> "this Op is cool";

    @BeforeAll
    public static void additionalSetup() {
        ops.register(new Object[]{new InfoTreeTest()});
        ops.register(new Object[]{new ComplexOp()});
        OpInfo info = InfoTreeTest.singularInfoOfName("test.infoTree");
        simpleTree = new InfoTree(info);
        OpInfo complexInfo = InfoTreeTest.singularInfoOfName("test.infoTreeBase");
        complexTree = new InfoTree(complexInfo, Collections.singletonList(simpleTree));
    }

    @Test
    public void testInfoTreeInstantiation() {
        Nil nil = new Nil<Producer<String>>(){};
        Producer op = (Producer)ops.opFromInfoTree(simpleTree, nil);
        Assertions.assertEquals((Object)S, (Object)op.create());
        nil = new Nil<Producer<String>>(){};
        op = (Producer)ops.opFromInfoTree(complexTree, nil);
        Assertions.assertEquals((Object)S, (Object)op.create());
    }

    @Test
    public void testInfoTreeToString() {
        Assertions.assertEquals((Object)simpleTree.info().implementationName(), (Object)simpleTree.toString());
        StringBuilder sb = new StringBuilder();
        sb.append(complexTree.info().implementationName());
        sb.append("\n\tDepends upon: ");
        sb.append(((InfoTree)complexTree.dependencies().get(0)).info().implementationName());
        Assertions.assertEquals((Object)sb.toString(), (Object)complexTree.toString());
    }

    private static OpInfo singularInfoOfName(String name) {
        Iterator infos = ops.infos(name).iterator();
        Assertions.assertTrue((boolean)infos.hasNext());
        OpInfo info = (OpInfo)infos.next();
        Assertions.assertFalse((boolean)infos.hasNext());
        return info;
    }
}

