/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.function.Inplaces;
import org.scijava.function.Producer;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.OpBuilderTestOps;

public class OpBuilderTest
extends AbstractTestEnvironment {
    final double[] halves = new double[10];

    public OpBuilderTest() {
        for (int i = 0; i < this.halves.length; ++i) {
            this.halves[i] = (double)i / 2.0;
        }
    }

    @BeforeAll
    public static void AddNeededOps() {
        ops.register(new Object[]{new OpBuilderTestOps()});
    }

    @Test
    public void testArity0_OU_matchF() {
        Producer op = this.name("test.addDoubles").producer();
        Object result = op.create();
        Assertions.assertEquals((Object)0.0, (Object)result);
    }

    @Test
    public void testArity0_OU_runF() {
        Object result = this.name("test.addDoubles").create();
        Assertions.assertEquals((Object)0.0, (Object)result);
    }

    @Test
    public void testArity0_OT_matchF() {
        Double expected = 0.0;
        Producer op = this.name("test.addDoubles").outType(Double.class).producer();
        Object result = op.create();
        Assertions.assertEquals((Object)result, (Object)expected);
    }

    @Test
    public void testArity0_OT_matchC() {
        double[] actual = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{0.0, 0.0, 0.0};
        Computers.Arity0 op = this.name("test.addArrays").outType(double[].class).computer();
        op.compute((Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity0_OT_runF() {
        Double result = (Double)this.name("test.addDoubles").outType(Double.class).create();
        assert (0.0 == result);
    }

    @Test
    public void testArity0_OV_matchC() {
        double[] result = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{0.0, 0.0, 0.0};
        Computers.Arity0 op = this.name("test.addArrays").output((Object)result).computer();
        op.compute((Object)result);
        Assertions.assertTrue((boolean)Arrays.equals(expected, result));
    }

    @Test
    public void testArity0_OV_runC() {
        double[] result = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{0.0, 0.0, 0.0};
        this.name("test.addArrays").output((Object)result).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, result));
    }

    @Test
    public void testArity1_IT_OU_matchF() {
        Double input = 1.0;
        Double expected = 1.0;
        Function op = this.name("test.addDoubles").inType(Double.class).function();
        Object actual = op.apply(input);
        Assertions.assertEquals((Object)expected, actual);
    }

    @Test
    public void testArity1_IT_OU_matchI1() {
        double[] input = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2.0, 3.0};
        Inplaces.Arity1 op = this.name("test.mulArrays1_1").inType(double[].class).inplace();
        op.mutate((Object)input);
        Assertions.assertTrue((boolean)Arrays.equals(input, expected));
    }

    @Test
    public void testArity1_IT_OT_matchF() {
        Double input = 1.0;
        Double expected = 1.0;
        Function op = this.name("test.addDoubles").inType(Double.class).outType(Double.class).function();
        double actual = (Double)op.apply(input);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity1_IT_OT_matchC() {
        double[] input = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{1.0, 2.0, 3.0};
        Computers.Arity1 op = this.name("test.addArrays").inType(double[].class).outType(double[].class).computer();
        op.compute((Object)input, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity1_IV_OU_matchF() {
        Double input = 1.0;
        Double expected = 1.0;
        Function op = this.name("test.addDoubles").input((Object)input).function();
        Object actual = op.apply(input);
        Assertions.assertEquals((Object)expected, actual);
    }

    @Test
    public void testArity1_IV_OU_matchI1() {
        double[] input = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2.0, 3.0};
        Inplaces.Arity1 op = this.name("test.mulArrays1_1").input((Object)input).inplace();
        op.mutate((Object)input);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input));
    }

    @Test
    public void testArity1_IV_OU_runF() {
        Double input = 1.0;
        Double expected = 1.0;
        Object actual = this.name("test.addDoubles").input((Object)input).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity1_IV_OU_runI1() {
        double[] input = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2.0, 3.0};
        this.name("test.mulArrays1_1").input((Object)input).mutate();
        Assertions.assertTrue((boolean)Arrays.equals(input, expected));
    }

    @Test
    public void testArity1_IV_OT_matchF() {
        Double input = 1.0;
        Double expected = 1.0;
        Function op = this.name("test.addDoubles").input((Object)input).outType(Double.class).function();
        double actual = (Double)op.apply(input);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity1_IV_OT_matchC() {
        double[] input = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{1.0, 2.0, 3.0};
        Computers.Arity1 op = this.name("test.addArrays").input((Object)input).output((Object)actual).computer();
        op.compute((Object)input, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity1_IV_OT_runF() {
        Double input = 1.0;
        Double expected = 1.0;
        Object actual = this.name("test.addDoubles").input((Object)input).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity1_IV_OV_matchC() {
        double[] input = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{1.0, 2.0, 3.0};
        Computers.Arity1 op = this.name("test.addArrays").input((Object)input).output((Object)actual).computer();
        op.compute((Object)input, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity1_IV_OV_runC() {
        double[] input = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{1.0, 2.0, 3.0};
        this.name("test.addArrays").input((Object)input).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity2_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double expected = 2.0;
        BiFunction op = this.name("test.addDoubles").inType(Double.class, Double.class).function();
        Object actual = op.apply(input1, input2);
        Assertions.assertEquals((Object)expected, actual);
    }

    @Test
    public void testArity2_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4.0, 9.0};
        Inplaces.Arity2_1 op = this.name("test.mulArrays2_1").inType(double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity2_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4.0, 9.0};
        Inplaces.Arity2_2 op = this.name("test.mulArrays2_2").inType(double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity2_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double expected = 2.0;
        BiFunction op = this.name("test.addDoubles").inType(Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply(input1, input2);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity2_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{2.0, 4.0, 6.0};
        Computers.Arity2 op = this.name("test.addArrays").inType(double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity2_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double expected = 2.0;
        BiFunction op = this.name("test.addDoubles").input((Object)input1, (Object)input2).function();
        Object actual = op.apply(input1, input2);
        Assertions.assertEquals((Object)expected, actual);
    }

    @Test
    public void testArity2_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4.0, 9.0};
        Inplaces.Arity2_1 op = this.name("test.mulArrays2_1").input((Object)input1, (Object)input2).inplace1();
        op.mutate((Object)input1, (Object)input2);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity2_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4.0, 9.0};
        Inplaces.Arity2_2 op = this.name("test.mulArrays2_2").input((Object)input1, (Object)input2).inplace2();
        op.mutate((Object)input1, (Object)input2);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity2_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double expected = 2.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity2_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4.0, 9.0};
        this.name("test.mulArrays2_1").input((Object)input1, (Object)input2).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity2_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4.0, 9.0};
        this.name("test.mulArrays2_2").input((Object)input1, (Object)input2).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity2_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double expected = 2.0;
        BiFunction op = this.name("test.addDoubles").input((Object)input1, (Object)input2).outType(Double.class).function();
        double actual = (Double)op.apply(input1, input2);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity2_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{2.0, 4.0, 6.0};
        Computers.Arity2 op = this.name("test.addArrays").input((Object)input1, (Object)input2).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity2_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double expected = 2.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity2_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{2.0, 4.0, 6.0};
        Computers.Arity2 op = this.name("test.addArrays").input((Object)input1, (Object)input2).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity2_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{2.0, 4.0, 6.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity3_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double expected = 3.0;
        Functions.Arity3 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity3_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8.0, 27.0};
        Inplaces.Arity3_1 op = this.name("test.mulArrays3_1").inType(double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity3_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8.0, 27.0};
        Inplaces.Arity3_2 op = this.name("test.mulArrays3_2").inType(double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity3_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8.0, 27.0};
        Inplaces.Arity3_3 op = this.name("test.mulArrays3_3").inType(double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity3_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double expected = 3.0;
        Functions.Arity3 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity3_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{3.0, 6.0, 9.0};
        Computers.Arity3 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity3_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double expected = 3.0;
        Functions.Arity3 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity3_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8.0, 27.0};
        Inplaces.Arity3_1 op = this.name("test.mulArrays3_1").input((Object)input1, (Object)input2, (Object)input3).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity3_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8.0, 27.0};
        Inplaces.Arity3_2 op = this.name("test.mulArrays3_2").input((Object)input1, (Object)input2, (Object)input3).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity3_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8.0, 27.0};
        Inplaces.Arity3_3 op = this.name("test.mulArrays3_3").input((Object)input1, (Object)input2, (Object)input3).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity3_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double expected = 3.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity3_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8.0, 27.0};
        this.name("test.mulArrays3_1").input((Object)input1, (Object)input2, (Object)input3).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity3_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8.0, 27.0};
        this.name("test.mulArrays3_2").input((Object)input1, (Object)input2, (Object)input3).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity3_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8.0, 27.0};
        this.name("test.mulArrays3_3").input((Object)input1, (Object)input2, (Object)input3).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity3_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double expected = 3.0;
        Functions.Arity3 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity3_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{3.0, 6.0, 9.0};
        Computers.Arity3 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity3_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double expected = 3.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity3_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{3.0, 6.0, 9.0};
        Computers.Arity3 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity3_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{3.0, 6.0, 9.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity4_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double expected = 4.0;
        Functions.Arity4 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity4_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        Inplaces.Arity4_1 op = this.name("test.mulArrays4_1").inType(double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity4_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        Inplaces.Arity4_2 op = this.name("test.mulArrays4_2").inType(double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity4_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        Inplaces.Arity4_3 op = this.name("test.mulArrays4_3").inType(double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity4_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        Inplaces.Arity4_4 op = this.name("test.mulArrays4_4").inType(double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity4_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double expected = 4.0;
        Functions.Arity4 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity4_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{4.0, 8.0, 12.0};
        Computers.Arity4 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity4_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double expected = 4.0;
        Functions.Arity4 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity4_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        Inplaces.Arity4_1 op = this.name("test.mulArrays4_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity4_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        Inplaces.Arity4_2 op = this.name("test.mulArrays4_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity4_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        Inplaces.Arity4_3 op = this.name("test.mulArrays4_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity4_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        Inplaces.Arity4_4 op = this.name("test.mulArrays4_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity4_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double expected = 4.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity4_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        this.name("test.mulArrays4_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity4_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        this.name("test.mulArrays4_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity4_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        this.name("test.mulArrays4_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity4_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        this.name("test.mulArrays4_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity4_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double expected = 4.0;
        Functions.Arity4 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity4_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{4.0, 8.0, 12.0};
        Computers.Arity4 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity4_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double expected = 4.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity4_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{4.0, 8.0, 12.0};
        Computers.Arity4 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity4_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{4.0, 8.0, 12.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity5_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double expected = 5.0;
        Functions.Arity5 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity5_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        Inplaces.Arity5_1 op = this.name("test.mulArrays5_1").inType(double[].class, double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity5_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        Inplaces.Arity5_2 op = this.name("test.mulArrays5_2").inType(double[].class, double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity5_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        Inplaces.Arity5_3 op = this.name("test.mulArrays5_3").inType(double[].class, double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity5_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        Inplaces.Arity5_4 op = this.name("test.mulArrays5_4").inType(double[].class, double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity5_IT_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        Inplaces.Arity5_5 op = this.name("test.mulArrays5_5").inType(double[].class, double[].class, double[].class, double[].class, double[].class).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity5_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double expected = 5.0;
        Functions.Arity5 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity5_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{5.0, 10.0, 15.0};
        Computers.Arity5 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity5_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double expected = 5.0;
        Functions.Arity5 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity5_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        Inplaces.Arity5_1 op = this.name("test.mulArrays5_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity5_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        Inplaces.Arity5_2 op = this.name("test.mulArrays5_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity5_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        Inplaces.Arity5_3 op = this.name("test.mulArrays5_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity5_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        Inplaces.Arity5_4 op = this.name("test.mulArrays5_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity5_IV_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        Inplaces.Arity5_5 op = this.name("test.mulArrays5_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input5));
    }

    @Test
    public void testArity5_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double expected = 5.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity5_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        this.name("test.mulArrays5_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity5_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        this.name("test.mulArrays5_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity5_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        this.name("test.mulArrays5_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity5_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        this.name("test.mulArrays5_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity5_IV_OU_runI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        this.name("test.mulArrays5_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).mutate5();
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity5_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double expected = 5.0;
        Functions.Arity5 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity5_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{5.0, 10.0, 15.0};
        Computers.Arity5 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity5_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double expected = 5.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity5_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{5.0, 10.0, 15.0};
        Computers.Arity5 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity5_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{5.0, 10.0, 15.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity6_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double expected = 6.0;
        Functions.Arity6 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity6_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        Inplaces.Arity6_1 op = this.name("test.mulArrays6_1").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity6_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        Inplaces.Arity6_2 op = this.name("test.mulArrays6_2").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity6_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        Inplaces.Arity6_3 op = this.name("test.mulArrays6_3").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity6_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        Inplaces.Arity6_4 op = this.name("test.mulArrays6_4").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity6_IT_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        Inplaces.Arity6_5 op = this.name("test.mulArrays6_5").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity6_IT_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        Inplaces.Arity6_6 op = this.name("test.mulArrays6_6").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity6_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double expected = 6.0;
        Functions.Arity6 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity6_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{6.0, 12.0, 18.0};
        Computers.Arity6 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity6_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double expected = 6.0;
        Functions.Arity6 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity6_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        Inplaces.Arity6_1 op = this.name("test.mulArrays6_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity6_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        Inplaces.Arity6_2 op = this.name("test.mulArrays6_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity6_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        Inplaces.Arity6_3 op = this.name("test.mulArrays6_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity6_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        Inplaces.Arity6_4 op = this.name("test.mulArrays6_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity6_IV_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        Inplaces.Arity6_5 op = this.name("test.mulArrays6_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input5));
    }

    @Test
    public void testArity6_IV_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        Inplaces.Arity6_6 op = this.name("test.mulArrays6_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input6));
    }

    @Test
    public void testArity6_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double expected = 6.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity6_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        this.name("test.mulArrays6_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity6_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        this.name("test.mulArrays6_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity6_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        this.name("test.mulArrays6_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity6_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        this.name("test.mulArrays6_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity6_IV_OU_runI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        this.name("test.mulArrays6_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).mutate5();
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity6_IV_OU_runI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        this.name("test.mulArrays6_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).mutate6();
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity6_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double expected = 6.0;
        Functions.Arity6 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity6_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{6.0, 12.0, 18.0};
        Computers.Arity6 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity6_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double expected = 6.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity6_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{6.0, 12.0, 18.0};
        Computers.Arity6 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity6_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{6.0, 12.0, 18.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity7_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double expected = 7.0;
        Functions.Arity7 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity7_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_1 op = this.name("test.mulArrays7_1").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity7_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_2 op = this.name("test.mulArrays7_2").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity7_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_3 op = this.name("test.mulArrays7_3").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity7_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_4 op = this.name("test.mulArrays7_4").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity7_IT_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_5 op = this.name("test.mulArrays7_5").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity7_IT_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_6 op = this.name("test.mulArrays7_6").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity7_IT_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_7 op = this.name("test.mulArrays7_7").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity7_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double expected = 7.0;
        Functions.Arity7 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity7_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{7.0, 14.0, 21.0};
        Computers.Arity7 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity7_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double expected = 7.0;
        Functions.Arity7 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity7_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_1 op = this.name("test.mulArrays7_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity7_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_2 op = this.name("test.mulArrays7_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity7_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_3 op = this.name("test.mulArrays7_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity7_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_4 op = this.name("test.mulArrays7_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity7_IV_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_5 op = this.name("test.mulArrays7_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input5));
    }

    @Test
    public void testArity7_IV_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_6 op = this.name("test.mulArrays7_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input6));
    }

    @Test
    public void testArity7_IV_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        Inplaces.Arity7_7 op = this.name("test.mulArrays7_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input7));
    }

    @Test
    public void testArity7_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double expected = 7.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity7_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        this.name("test.mulArrays7_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity7_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        this.name("test.mulArrays7_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity7_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        this.name("test.mulArrays7_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity7_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        this.name("test.mulArrays7_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity7_IV_OU_runI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        this.name("test.mulArrays7_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).mutate5();
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity7_IV_OU_runI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        this.name("test.mulArrays7_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).mutate6();
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity7_IV_OU_runI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        this.name("test.mulArrays7_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).mutate7();
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity7_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double expected = 7.0;
        Functions.Arity7 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity7_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{7.0, 14.0, 21.0};
        Computers.Arity7 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity7_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double expected = 7.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity7_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{7.0, 14.0, 21.0};
        Computers.Arity7 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity7_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{7.0, 14.0, 21.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity8_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double expected = 8.0;
        Functions.Arity8 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity8_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_1 op = this.name("test.mulArrays8_1").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity8_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_2 op = this.name("test.mulArrays8_2").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity8_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_3 op = this.name("test.mulArrays8_3").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity8_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_4 op = this.name("test.mulArrays8_4").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity8_IT_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_5 op = this.name("test.mulArrays8_5").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity8_IT_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_6 op = this.name("test.mulArrays8_6").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity8_IT_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_7 op = this.name("test.mulArrays8_7").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity8_IT_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_8 op = this.name("test.mulArrays8_8").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity8_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double expected = 8.0;
        Functions.Arity8 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity8_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{8.0, 16.0, 24.0};
        Computers.Arity8 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity8_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double expected = 8.0;
        Functions.Arity8 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity8_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_1 op = this.name("test.mulArrays8_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity8_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_2 op = this.name("test.mulArrays8_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity8_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_3 op = this.name("test.mulArrays8_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity8_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_4 op = this.name("test.mulArrays8_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity8_IV_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_5 op = this.name("test.mulArrays8_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input5));
    }

    @Test
    public void testArity8_IV_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_6 op = this.name("test.mulArrays8_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input6));
    }

    @Test
    public void testArity8_IV_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_7 op = this.name("test.mulArrays8_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input7));
    }

    @Test
    public void testArity8_IV_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        Inplaces.Arity8_8 op = this.name("test.mulArrays8_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input8));
    }

    @Test
    public void testArity8_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double expected = 8.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity8_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        this.name("test.mulArrays8_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity8_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        this.name("test.mulArrays8_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity8_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        this.name("test.mulArrays8_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity8_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        this.name("test.mulArrays8_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity8_IV_OU_runI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        this.name("test.mulArrays8_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).mutate5();
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity8_IV_OU_runI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        this.name("test.mulArrays8_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).mutate6();
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity8_IV_OU_runI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        this.name("test.mulArrays8_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).mutate7();
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity8_IV_OU_runI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        this.name("test.mulArrays8_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).mutate8();
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity8_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double expected = 8.0;
        Functions.Arity8 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity8_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{8.0, 16.0, 24.0};
        Computers.Arity8 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity8_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double expected = 8.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity8_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{8.0, 16.0, 24.0};
        Computers.Arity8 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity8_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{8.0, 16.0, 24.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity9_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double expected = 9.0;
        Functions.Arity9 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity9_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_1 op = this.name("test.mulArrays9_1").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity9_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_2 op = this.name("test.mulArrays9_2").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity9_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_3 op = this.name("test.mulArrays9_3").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity9_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_4 op = this.name("test.mulArrays9_4").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity9_IT_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_5 op = this.name("test.mulArrays9_5").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity9_IT_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_6 op = this.name("test.mulArrays9_6").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity9_IT_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_7 op = this.name("test.mulArrays9_7").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity9_IT_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_8 op = this.name("test.mulArrays9_8").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity9_IT_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_9 op = this.name("test.mulArrays9_9").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity9_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double expected = 9.0;
        Functions.Arity9 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity9_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{9.0, 18.0, 27.0};
        Computers.Arity9 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity9_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double expected = 9.0;
        Functions.Arity9 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity9_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_1 op = this.name("test.mulArrays9_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity9_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_2 op = this.name("test.mulArrays9_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity9_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_3 op = this.name("test.mulArrays9_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity9_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_4 op = this.name("test.mulArrays9_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity9_IV_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_5 op = this.name("test.mulArrays9_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input5));
    }

    @Test
    public void testArity9_IV_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_6 op = this.name("test.mulArrays9_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input6));
    }

    @Test
    public void testArity9_IV_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_7 op = this.name("test.mulArrays9_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input7));
    }

    @Test
    public void testArity9_IV_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_8 op = this.name("test.mulArrays9_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input8));
    }

    @Test
    public void testArity9_IV_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        Inplaces.Arity9_9 op = this.name("test.mulArrays9_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input9));
    }

    @Test
    public void testArity9_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double expected = 9.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity9_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        this.name("test.mulArrays9_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity9_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        this.name("test.mulArrays9_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity9_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        this.name("test.mulArrays9_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity9_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        this.name("test.mulArrays9_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity9_IV_OU_runI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        this.name("test.mulArrays9_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).mutate5();
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity9_IV_OU_runI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        this.name("test.mulArrays9_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).mutate6();
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity9_IV_OU_runI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        this.name("test.mulArrays9_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).mutate7();
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity9_IV_OU_runI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        this.name("test.mulArrays9_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).mutate8();
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity9_IV_OU_runI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        this.name("test.mulArrays9_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).mutate9();
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity9_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double expected = 9.0;
        Functions.Arity9 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity9_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{9.0, 18.0, 27.0};
        Computers.Arity9 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity9_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double expected = 9.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity9_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{9.0, 18.0, 27.0};
        Computers.Arity9 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity9_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{9.0, 18.0, 27.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity10_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double expected = 10.0;
        Functions.Arity10 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity10_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_1 op = this.name("test.mulArrays10_1").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity10_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_2 op = this.name("test.mulArrays10_2").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity10_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_3 op = this.name("test.mulArrays10_3").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity10_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_4 op = this.name("test.mulArrays10_4").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity10_IT_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_5 op = this.name("test.mulArrays10_5").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity10_IT_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_6 op = this.name("test.mulArrays10_6").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity10_IT_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_7 op = this.name("test.mulArrays10_7").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity10_IT_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_8 op = this.name("test.mulArrays10_8").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity10_IT_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_9 op = this.name("test.mulArrays10_9").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity10_IT_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_10 op = this.name("test.mulArrays10_10").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity10_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double expected = 10.0;
        Functions.Arity10 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity10_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{10.0, 20.0, 30.0};
        Computers.Arity10 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity10_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double expected = 10.0;
        Functions.Arity10 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity10_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_1 op = this.name("test.mulArrays10_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity10_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_2 op = this.name("test.mulArrays10_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity10_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_3 op = this.name("test.mulArrays10_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity10_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_4 op = this.name("test.mulArrays10_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity10_IV_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_5 op = this.name("test.mulArrays10_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input5));
    }

    @Test
    public void testArity10_IV_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_6 op = this.name("test.mulArrays10_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input6));
    }

    @Test
    public void testArity10_IV_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_7 op = this.name("test.mulArrays10_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input7));
    }

    @Test
    public void testArity10_IV_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_8 op = this.name("test.mulArrays10_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input8));
    }

    @Test
    public void testArity10_IV_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_9 op = this.name("test.mulArrays10_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input9));
    }

    @Test
    public void testArity10_IV_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        Inplaces.Arity10_10 op = this.name("test.mulArrays10_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input10));
    }

    @Test
    public void testArity10_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double expected = 10.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity10_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        this.name("test.mulArrays10_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity10_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        this.name("test.mulArrays10_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity10_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        this.name("test.mulArrays10_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity10_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        this.name("test.mulArrays10_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity10_IV_OU_runI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        this.name("test.mulArrays10_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).mutate5();
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity10_IV_OU_runI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        this.name("test.mulArrays10_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).mutate6();
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity10_IV_OU_runI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        this.name("test.mulArrays10_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).mutate7();
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity10_IV_OU_runI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        this.name("test.mulArrays10_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).mutate8();
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity10_IV_OU_runI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        this.name("test.mulArrays10_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).mutate9();
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity10_IV_OU_runI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        this.name("test.mulArrays10_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).mutate10();
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity10_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double expected = 10.0;
        Functions.Arity10 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity10_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{10.0, 20.0, 30.0};
        Computers.Arity10 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity10_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double expected = 10.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity10_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{10.0, 20.0, 30.0};
        Computers.Arity10 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity10_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{10.0, 20.0, 30.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity11_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double expected = 11.0;
        Functions.Arity11 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity11_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_1 op = this.name("test.mulArrays11_1").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity11_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_2 op = this.name("test.mulArrays11_2").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity11_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_3 op = this.name("test.mulArrays11_3").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity11_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_4 op = this.name("test.mulArrays11_4").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity11_IT_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_5 op = this.name("test.mulArrays11_5").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity11_IT_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_6 op = this.name("test.mulArrays11_6").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity11_IT_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_7 op = this.name("test.mulArrays11_7").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity11_IT_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_8 op = this.name("test.mulArrays11_8").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity11_IT_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_9 op = this.name("test.mulArrays11_9").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity11_IT_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_10 op = this.name("test.mulArrays11_10").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity11_IT_OU_matchI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_11 op = this.name("test.mulArrays11_11").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace11();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(input11, expected));
    }

    @Test
    public void testArity11_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double expected = 11.0;
        Functions.Arity11 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity11_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{11.0, 22.0, 33.0};
        Computers.Arity11 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity11_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double expected = 11.0;
        Functions.Arity11 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity11_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_1 op = this.name("test.mulArrays11_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity11_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_2 op = this.name("test.mulArrays11_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity11_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_3 op = this.name("test.mulArrays11_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity11_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_4 op = this.name("test.mulArrays11_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity11_IV_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_5 op = this.name("test.mulArrays11_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input5));
    }

    @Test
    public void testArity11_IV_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_6 op = this.name("test.mulArrays11_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input6));
    }

    @Test
    public void testArity11_IV_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_7 op = this.name("test.mulArrays11_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input7));
    }

    @Test
    public void testArity11_IV_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_8 op = this.name("test.mulArrays11_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input8));
    }

    @Test
    public void testArity11_IV_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_9 op = this.name("test.mulArrays11_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input9));
    }

    @Test
    public void testArity11_IV_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_10 op = this.name("test.mulArrays11_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input10));
    }

    @Test
    public void testArity11_IV_OU_matchI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        Inplaces.Arity11_11 op = this.name("test.mulArrays11_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).inplace11();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input11));
    }

    @Test
    public void testArity11_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double expected = 11.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity11_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        this.name("test.mulArrays11_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity11_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        this.name("test.mulArrays11_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity11_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        this.name("test.mulArrays11_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity11_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        this.name("test.mulArrays11_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity11_IV_OU_runI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        this.name("test.mulArrays11_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).mutate5();
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity11_IV_OU_runI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        this.name("test.mulArrays11_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).mutate6();
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity11_IV_OU_runI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        this.name("test.mulArrays11_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).mutate7();
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity11_IV_OU_runI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        this.name("test.mulArrays11_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).mutate8();
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity11_IV_OU_runI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        this.name("test.mulArrays11_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).mutate9();
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity11_IV_OU_runI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        this.name("test.mulArrays11_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).mutate10();
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity11_IV_OU_runI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        this.name("test.mulArrays11_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).mutate11();
        Assertions.assertTrue((boolean)Arrays.equals(input11, expected));
    }

    @Test
    public void testArity11_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double expected = 11.0;
        Functions.Arity11 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity11_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{11.0, 22.0, 33.0};
        Computers.Arity11 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity11_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double expected = 11.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity11_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{11.0, 22.0, 33.0};
        Computers.Arity11 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity11_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{11.0, 22.0, 33.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity12_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double expected = 12.0;
        Functions.Arity12 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity12_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_1 op = this.name("test.mulArrays12_1").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity12_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_2 op = this.name("test.mulArrays12_2").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity12_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_3 op = this.name("test.mulArrays12_3").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity12_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_4 op = this.name("test.mulArrays12_4").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity12_IT_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_5 op = this.name("test.mulArrays12_5").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity12_IT_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_6 op = this.name("test.mulArrays12_6").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity12_IT_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_7 op = this.name("test.mulArrays12_7").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity12_IT_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_8 op = this.name("test.mulArrays12_8").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity12_IT_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_9 op = this.name("test.mulArrays12_9").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity12_IT_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_10 op = this.name("test.mulArrays12_10").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity12_IT_OU_matchI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_11 op = this.name("test.mulArrays12_11").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace11();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(input11, expected));
    }

    @Test
    public void testArity12_IT_OU_matchI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_12 op = this.name("test.mulArrays12_12").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace12();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(input12, expected));
    }

    @Test
    public void testArity12_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double expected = 12.0;
        Functions.Arity12 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity12_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{12.0, 24.0, 36.0};
        Computers.Arity12 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity12_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double expected = 12.0;
        Functions.Arity12 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity12_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_1 op = this.name("test.mulArrays12_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity12_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_2 op = this.name("test.mulArrays12_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity12_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_3 op = this.name("test.mulArrays12_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity12_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_4 op = this.name("test.mulArrays12_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity12_IV_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_5 op = this.name("test.mulArrays12_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input5));
    }

    @Test
    public void testArity12_IV_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_6 op = this.name("test.mulArrays12_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input6));
    }

    @Test
    public void testArity12_IV_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_7 op = this.name("test.mulArrays12_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input7));
    }

    @Test
    public void testArity12_IV_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_8 op = this.name("test.mulArrays12_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input8));
    }

    @Test
    public void testArity12_IV_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_9 op = this.name("test.mulArrays12_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input9));
    }

    @Test
    public void testArity12_IV_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_10 op = this.name("test.mulArrays12_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input10));
    }

    @Test
    public void testArity12_IV_OU_matchI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_11 op = this.name("test.mulArrays12_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).inplace11();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input11));
    }

    @Test
    public void testArity12_IV_OU_matchI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        Inplaces.Arity12_12 op = this.name("test.mulArrays12_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).inplace12();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input12));
    }

    @Test
    public void testArity12_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double expected = 12.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity12_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        this.name("test.mulArrays12_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity12_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        this.name("test.mulArrays12_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity12_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        this.name("test.mulArrays12_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity12_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        this.name("test.mulArrays12_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity12_IV_OU_runI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        this.name("test.mulArrays12_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).mutate5();
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity12_IV_OU_runI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        this.name("test.mulArrays12_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).mutate6();
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity12_IV_OU_runI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        this.name("test.mulArrays12_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).mutate7();
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity12_IV_OU_runI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        this.name("test.mulArrays12_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).mutate8();
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity12_IV_OU_runI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        this.name("test.mulArrays12_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).mutate9();
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity12_IV_OU_runI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        this.name("test.mulArrays12_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).mutate10();
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity12_IV_OU_runI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        this.name("test.mulArrays12_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).mutate11();
        Assertions.assertTrue((boolean)Arrays.equals(input11, expected));
    }

    @Test
    public void testArity12_IV_OU_runI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        this.name("test.mulArrays12_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).mutate12();
        Assertions.assertTrue((boolean)Arrays.equals(input12, expected));
    }

    @Test
    public void testArity12_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double expected = 12.0;
        Functions.Arity12 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity12_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{12.0, 24.0, 36.0};
        Computers.Arity12 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity12_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double expected = 12.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity12_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{12.0, 24.0, 36.0};
        Computers.Arity12 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity12_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{12.0, 24.0, 36.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity13_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double expected = 13.0;
        Functions.Arity13 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity13_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_1 op = this.name("test.mulArrays13_1").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity13_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_2 op = this.name("test.mulArrays13_2").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity13_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_3 op = this.name("test.mulArrays13_3").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity13_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_4 op = this.name("test.mulArrays13_4").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity13_IT_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_5 op = this.name("test.mulArrays13_5").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity13_IT_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_6 op = this.name("test.mulArrays13_6").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity13_IT_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_7 op = this.name("test.mulArrays13_7").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity13_IT_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_8 op = this.name("test.mulArrays13_8").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity13_IT_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_9 op = this.name("test.mulArrays13_9").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity13_IT_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_10 op = this.name("test.mulArrays13_10").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity13_IT_OU_matchI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_11 op = this.name("test.mulArrays13_11").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace11();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input11, expected));
    }

    @Test
    public void testArity13_IT_OU_matchI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_12 op = this.name("test.mulArrays13_12").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace12();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input12, expected));
    }

    @Test
    public void testArity13_IT_OU_matchI13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_13 op = this.name("test.mulArrays13_13").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace13();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(input13, expected));
    }

    @Test
    public void testArity13_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double expected = 13.0;
        Functions.Arity13 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity13_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{13.0, 26.0, 39.0};
        Computers.Arity13 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity13_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double expected = 13.0;
        Functions.Arity13 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity13_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_1 op = this.name("test.mulArrays13_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity13_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_2 op = this.name("test.mulArrays13_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity13_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_3 op = this.name("test.mulArrays13_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity13_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_4 op = this.name("test.mulArrays13_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity13_IV_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_5 op = this.name("test.mulArrays13_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input5));
    }

    @Test
    public void testArity13_IV_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_6 op = this.name("test.mulArrays13_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input6));
    }

    @Test
    public void testArity13_IV_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_7 op = this.name("test.mulArrays13_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input7));
    }

    @Test
    public void testArity13_IV_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_8 op = this.name("test.mulArrays13_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input8));
    }

    @Test
    public void testArity13_IV_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_9 op = this.name("test.mulArrays13_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input9));
    }

    @Test
    public void testArity13_IV_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_10 op = this.name("test.mulArrays13_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input10));
    }

    @Test
    public void testArity13_IV_OU_matchI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_11 op = this.name("test.mulArrays13_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace11();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input11));
    }

    @Test
    public void testArity13_IV_OU_matchI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_12 op = this.name("test.mulArrays13_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace12();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input12));
    }

    @Test
    public void testArity13_IV_OU_matchI13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        Inplaces.Arity13_13 op = this.name("test.mulArrays13_13").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).inplace13();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input13));
    }

    @Test
    public void testArity13_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double expected = 13.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity13_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity13_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity13_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity13_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity13_IV_OU_runI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate5();
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity13_IV_OU_runI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate6();
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity13_IV_OU_runI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate7();
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity13_IV_OU_runI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate8();
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity13_IV_OU_runI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate9();
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity13_IV_OU_runI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate10();
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity13_IV_OU_runI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate11();
        Assertions.assertTrue((boolean)Arrays.equals(input11, expected));
    }

    @Test
    public void testArity13_IV_OU_runI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate12();
        Assertions.assertTrue((boolean)Arrays.equals(input12, expected));
    }

    @Test
    public void testArity13_IV_OU_runI13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        this.name("test.mulArrays13_13").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).mutate13();
        Assertions.assertTrue((boolean)Arrays.equals(input13, expected));
    }

    @Test
    public void testArity13_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double expected = 13.0;
        Functions.Arity13 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity13_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{13.0, 26.0, 39.0};
        Computers.Arity13 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity13_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double expected = 13.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity13_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{13.0, 26.0, 39.0};
        Computers.Arity13 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity13_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{13.0, 26.0, 39.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity14_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double expected = 14.0;
        Functions.Arity14 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity14_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_1 op = this.name("test.mulArrays14_1").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_2 op = this.name("test.mulArrays14_2").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_3 op = this.name("test.mulArrays14_3").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_4 op = this.name("test.mulArrays14_4").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_5 op = this.name("test.mulArrays14_5").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_6 op = this.name("test.mulArrays14_6").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_7 op = this.name("test.mulArrays14_7").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_8 op = this.name("test.mulArrays14_8").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_9 op = this.name("test.mulArrays14_9").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_10 op = this.name("test.mulArrays14_10").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_11 op = this.name("test.mulArrays14_11").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace11();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input11, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_12 op = this.name("test.mulArrays14_12").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace12();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input12, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_13 op = this.name("test.mulArrays14_13").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace13();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input13, expected));
    }

    @Test
    public void testArity14_IT_OU_matchI14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_14 op = this.name("test.mulArrays14_14").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace14();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(input14, expected));
    }

    @Test
    public void testArity14_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double expected = 14.0;
        Functions.Arity14 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity14_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{14.0, 28.0, 42.0};
        Computers.Arity14 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity14_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double expected = 14.0;
        Functions.Arity14 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity14_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_1 op = this.name("test.mulArrays14_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity14_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_2 op = this.name("test.mulArrays14_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity14_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_3 op = this.name("test.mulArrays14_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity14_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_4 op = this.name("test.mulArrays14_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity14_IV_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_5 op = this.name("test.mulArrays14_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input5));
    }

    @Test
    public void testArity14_IV_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_6 op = this.name("test.mulArrays14_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input6));
    }

    @Test
    public void testArity14_IV_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_7 op = this.name("test.mulArrays14_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input7));
    }

    @Test
    public void testArity14_IV_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_8 op = this.name("test.mulArrays14_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input8));
    }

    @Test
    public void testArity14_IV_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_9 op = this.name("test.mulArrays14_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input9));
    }

    @Test
    public void testArity14_IV_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_10 op = this.name("test.mulArrays14_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input10));
    }

    @Test
    public void testArity14_IV_OU_matchI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_11 op = this.name("test.mulArrays14_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace11();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input11));
    }

    @Test
    public void testArity14_IV_OU_matchI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_12 op = this.name("test.mulArrays14_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace12();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input12));
    }

    @Test
    public void testArity14_IV_OU_matchI13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_13 op = this.name("test.mulArrays14_13").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace13();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input13));
    }

    @Test
    public void testArity14_IV_OU_matchI14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        Inplaces.Arity14_14 op = this.name("test.mulArrays14_14").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).inplace14();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input14));
    }

    @Test
    public void testArity14_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double expected = 14.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity14_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity14_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity14_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity14_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity14_IV_OU_runI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate5();
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity14_IV_OU_runI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate6();
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity14_IV_OU_runI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate7();
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity14_IV_OU_runI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate8();
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity14_IV_OU_runI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate9();
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity14_IV_OU_runI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate10();
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity14_IV_OU_runI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate11();
        Assertions.assertTrue((boolean)Arrays.equals(input11, expected));
    }

    @Test
    public void testArity14_IV_OU_runI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate12();
        Assertions.assertTrue((boolean)Arrays.equals(input12, expected));
    }

    @Test
    public void testArity14_IV_OU_runI13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_13").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate13();
        Assertions.assertTrue((boolean)Arrays.equals(input13, expected));
    }

    @Test
    public void testArity14_IV_OU_runI14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        this.name("test.mulArrays14_14").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).mutate14();
        Assertions.assertTrue((boolean)Arrays.equals(input14, expected));
    }

    @Test
    public void testArity14_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double expected = 14.0;
        Functions.Arity14 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity14_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{14.0, 28.0, 42.0};
        Computers.Arity14 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity14_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double expected = 14.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity14_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{14.0, 28.0, 42.0};
        Computers.Arity14 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity14_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{14.0, 28.0, 42.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity15_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double input15 = 1.0;
        Double expected = 15.0;
        Functions.Arity15 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity15_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_1 op = this.name("test.mulArrays15_1").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_2 op = this.name("test.mulArrays15_2").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_3 op = this.name("test.mulArrays15_3").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_4 op = this.name("test.mulArrays15_4").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_5 op = this.name("test.mulArrays15_5").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_6 op = this.name("test.mulArrays15_6").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_7 op = this.name("test.mulArrays15_7").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_8 op = this.name("test.mulArrays15_8").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_9 op = this.name("test.mulArrays15_9").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_10 op = this.name("test.mulArrays15_10").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_11 op = this.name("test.mulArrays15_11").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace11();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input11, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_12 op = this.name("test.mulArrays15_12").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace12();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input12, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_13 op = this.name("test.mulArrays15_13").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace13();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input13, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_14 op = this.name("test.mulArrays15_14").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace14();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input14, expected));
    }

    @Test
    public void testArity15_IT_OU_matchI15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_15 op = this.name("test.mulArrays15_15").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace15();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(input15, expected));
    }

    @Test
    public void testArity15_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double input15 = 1.0;
        Double expected = 15.0;
        Functions.Arity15 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity15_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{15.0, 30.0, 45.0};
        Computers.Arity15 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity15_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double input15 = 1.0;
        Double expected = 15.0;
        Functions.Arity15 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity15_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_1 op = this.name("test.mulArrays15_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity15_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_2 op = this.name("test.mulArrays15_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity15_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_3 op = this.name("test.mulArrays15_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity15_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_4 op = this.name("test.mulArrays15_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity15_IV_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_5 op = this.name("test.mulArrays15_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input5));
    }

    @Test
    public void testArity15_IV_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_6 op = this.name("test.mulArrays15_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input6));
    }

    @Test
    public void testArity15_IV_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_7 op = this.name("test.mulArrays15_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input7));
    }

    @Test
    public void testArity15_IV_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_8 op = this.name("test.mulArrays15_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input8));
    }

    @Test
    public void testArity15_IV_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_9 op = this.name("test.mulArrays15_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input9));
    }

    @Test
    public void testArity15_IV_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_10 op = this.name("test.mulArrays15_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input10));
    }

    @Test
    public void testArity15_IV_OU_matchI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_11 op = this.name("test.mulArrays15_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace11();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input11));
    }

    @Test
    public void testArity15_IV_OU_matchI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_12 op = this.name("test.mulArrays15_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace12();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input12));
    }

    @Test
    public void testArity15_IV_OU_matchI13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_13 op = this.name("test.mulArrays15_13").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace13();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input13));
    }

    @Test
    public void testArity15_IV_OU_matchI14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_14 op = this.name("test.mulArrays15_14").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace14();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input14));
    }

    @Test
    public void testArity15_IV_OU_matchI15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        Inplaces.Arity15_15 op = this.name("test.mulArrays15_15").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).inplace15();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input15));
    }

    @Test
    public void testArity15_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double input15 = 1.0;
        Double expected = 15.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity15_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity15_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity15_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity15_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity15_IV_OU_runI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate5();
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity15_IV_OU_runI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate6();
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity15_IV_OU_runI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate7();
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity15_IV_OU_runI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate8();
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity15_IV_OU_runI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate9();
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity15_IV_OU_runI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate10();
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity15_IV_OU_runI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate11();
        Assertions.assertTrue((boolean)Arrays.equals(input11, expected));
    }

    @Test
    public void testArity15_IV_OU_runI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate12();
        Assertions.assertTrue((boolean)Arrays.equals(input12, expected));
    }

    @Test
    public void testArity15_IV_OU_runI13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_13").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate13();
        Assertions.assertTrue((boolean)Arrays.equals(input13, expected));
    }

    @Test
    public void testArity15_IV_OU_runI14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_14").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate14();
        Assertions.assertTrue((boolean)Arrays.equals(input14, expected));
    }

    @Test
    public void testArity15_IV_OU_runI15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        this.name("test.mulArrays15_15").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).mutate15();
        Assertions.assertTrue((boolean)Arrays.equals(input15, expected));
    }

    @Test
    public void testArity15_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double input15 = 1.0;
        Double expected = 15.0;
        Functions.Arity15 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity15_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{15.0, 30.0, 45.0};
        Computers.Arity15 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity15_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double input15 = 1.0;
        Double expected = 15.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity15_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{15.0, 30.0, 45.0};
        Computers.Arity15 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity15_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{15.0, 30.0, 45.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity16_IT_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double input15 = 1.0;
        Double input16 = 1.0;
        Double expected = 16.0;
        Functions.Arity16 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity16_IT_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_1 op = this.name("test.mulArrays16_1").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_2 op = this.name("test.mulArrays16_2").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_3 op = this.name("test.mulArrays16_3").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_4 op = this.name("test.mulArrays16_4").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_5 op = this.name("test.mulArrays16_5").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_6 op = this.name("test.mulArrays16_6").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_7 op = this.name("test.mulArrays16_7").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_8 op = this.name("test.mulArrays16_8").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_9 op = this.name("test.mulArrays16_9").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_10 op = this.name("test.mulArrays16_10").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_11 op = this.name("test.mulArrays16_11").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace11();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input11, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_12 op = this.name("test.mulArrays16_12").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace12();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input12, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_13 op = this.name("test.mulArrays16_13").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace13();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input13, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_14 op = this.name("test.mulArrays16_14").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace14();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input14, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_15 op = this.name("test.mulArrays16_15").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace15();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input15, expected));
    }

    @Test
    public void testArity16_IT_OU_matchI16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_16 op = this.name("test.mulArrays16_16").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).inplace16();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(input16, expected));
    }

    @Test
    public void testArity16_IT_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double input15 = 1.0;
        Double input16 = 1.0;
        Double expected = 16.0;
        Functions.Arity16 op = this.name("test.addDoubles").inType(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity16_IT_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{16.0, 32.0, 48.0};
        Computers.Arity16 op = this.name("test.addArrays").inType(double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class, double[].class).outType(double[].class).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity16_IV_OU_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double input15 = 1.0;
        Double input16 = 1.0;
        Double expected = 16.0;
        Functions.Arity16 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).function();
        Object actual = op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity16_IV_OU_matchI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_1 op = this.name("test.mulArrays16_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace1();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input1));
    }

    @Test
    public void testArity16_IV_OU_matchI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_2 op = this.name("test.mulArrays16_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace2();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input2));
    }

    @Test
    public void testArity16_IV_OU_matchI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_3 op = this.name("test.mulArrays16_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace3();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input3));
    }

    @Test
    public void testArity16_IV_OU_matchI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_4 op = this.name("test.mulArrays16_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace4();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input4));
    }

    @Test
    public void testArity16_IV_OU_matchI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_5 op = this.name("test.mulArrays16_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace5();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input5));
    }

    @Test
    public void testArity16_IV_OU_matchI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_6 op = this.name("test.mulArrays16_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace6();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input6));
    }

    @Test
    public void testArity16_IV_OU_matchI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_7 op = this.name("test.mulArrays16_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace7();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input7));
    }

    @Test
    public void testArity16_IV_OU_matchI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_8 op = this.name("test.mulArrays16_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace8();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input8));
    }

    @Test
    public void testArity16_IV_OU_matchI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_9 op = this.name("test.mulArrays16_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace9();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input9));
    }

    @Test
    public void testArity16_IV_OU_matchI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_10 op = this.name("test.mulArrays16_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace10();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input10));
    }

    @Test
    public void testArity16_IV_OU_matchI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_11 op = this.name("test.mulArrays16_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace11();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input11));
    }

    @Test
    public void testArity16_IV_OU_matchI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_12 op = this.name("test.mulArrays16_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace12();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input12));
    }

    @Test
    public void testArity16_IV_OU_matchI13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_13 op = this.name("test.mulArrays16_13").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace13();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input13));
    }

    @Test
    public void testArity16_IV_OU_matchI14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_14 op = this.name("test.mulArrays16_14").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace14();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input14));
    }

    @Test
    public void testArity16_IV_OU_matchI15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_15 op = this.name("test.mulArrays16_15").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace15();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input15));
    }

    @Test
    public void testArity16_IV_OU_matchI16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        Inplaces.Arity16_16 op = this.name("test.mulArrays16_16").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).inplace16();
        op.mutate((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertTrue((boolean)Arrays.equals(expected, input16));
    }

    @Test
    public void testArity16_IV_OU_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double input15 = 1.0;
        Double input16 = 1.0;
        Double expected = 16.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity16_IV_OU_runI1() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate1();
        Assertions.assertTrue((boolean)Arrays.equals(input1, expected));
    }

    @Test
    public void testArity16_IV_OU_runI2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate2();
        Assertions.assertTrue((boolean)Arrays.equals(input2, expected));
    }

    @Test
    public void testArity16_IV_OU_runI3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate3();
        Assertions.assertTrue((boolean)Arrays.equals(input3, expected));
    }

    @Test
    public void testArity16_IV_OU_runI4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate4();
        Assertions.assertTrue((boolean)Arrays.equals(input4, expected));
    }

    @Test
    public void testArity16_IV_OU_runI5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate5();
        Assertions.assertTrue((boolean)Arrays.equals(input5, expected));
    }

    @Test
    public void testArity16_IV_OU_runI6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate6();
        Assertions.assertTrue((boolean)Arrays.equals(input6, expected));
    }

    @Test
    public void testArity16_IV_OU_runI7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate7();
        Assertions.assertTrue((boolean)Arrays.equals(input7, expected));
    }

    @Test
    public void testArity16_IV_OU_runI8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate8();
        Assertions.assertTrue((boolean)Arrays.equals(input8, expected));
    }

    @Test
    public void testArity16_IV_OU_runI9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate9();
        Assertions.assertTrue((boolean)Arrays.equals(input9, expected));
    }

    @Test
    public void testArity16_IV_OU_runI10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate10();
        Assertions.assertTrue((boolean)Arrays.equals(input10, expected));
    }

    @Test
    public void testArity16_IV_OU_runI11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate11();
        Assertions.assertTrue((boolean)Arrays.equals(input11, expected));
    }

    @Test
    public void testArity16_IV_OU_runI12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate12();
        Assertions.assertTrue((boolean)Arrays.equals(input12, expected));
    }

    @Test
    public void testArity16_IV_OU_runI13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_13").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate13();
        Assertions.assertTrue((boolean)Arrays.equals(input13, expected));
    }

    @Test
    public void testArity16_IV_OU_runI14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_14").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate14();
        Assertions.assertTrue((boolean)Arrays.equals(input14, expected));
    }

    @Test
    public void testArity16_IV_OU_runI15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_15").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate15();
        Assertions.assertTrue((boolean)Arrays.equals(input15, expected));
    }

    @Test
    public void testArity16_IV_OU_runI16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        this.name("test.mulArrays16_16").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).mutate16();
        Assertions.assertTrue((boolean)Arrays.equals(input16, expected));
    }

    @Test
    public void testArity16_IV_OT_matchF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double input15 = 1.0;
        Double input16 = 1.0;
        Double expected = 16.0;
        Functions.Arity16 op = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType(Double.class).function();
        double actual = (Double)op.apply((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16);
        Assertions.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    @Test
    public void testArity16_IV_OT_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{16.0, 32.0, 48.0};
        Computers.Arity16 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity16_IV_OT_runF() {
        Double input1 = 1.0;
        Double input2 = 1.0;
        Double input3 = 1.0;
        Double input4 = 1.0;
        Double input5 = 1.0;
        Double input6 = 1.0;
        Double input7 = 1.0;
        Double input8 = 1.0;
        Double input9 = 1.0;
        Double input10 = 1.0;
        Double input11 = 1.0;
        Double input12 = 1.0;
        Double input13 = 1.0;
        Double input14 = 1.0;
        Double input15 = 1.0;
        Double input16 = 1.0;
        Double expected = 16.0;
        Object actual = this.name("test.addDoubles").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType(Double.class).apply();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArity16_IV_OV_matchC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{16.0, 32.0, 48.0};
        Computers.Arity16 op = this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).output((Object)actual).computer();
        op.compute((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16, (Object)actual);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testArity16_IV_OV_runC() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] actual = new double[]{0.0, 0.0, 0.0};
        double[] expected = new double[]{16.0, 32.0, 48.0};
        this.name("test.addArrays").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).output((Object)actual).compute();
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    private OpBuilder name(String opName) {
        return ops.op(opName);
    }
}

