/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.OpifyOp1;
import org.scijava.ops.engine.OpifyOp2;

public class OpEnvironmentTest
extends AbstractTestEnvironment {
    @Test
    public void testClassOpification() {
        OpInfo opifyOpInfo = ops.opify(OpifyOp1.class, new String[]{OpifyOp1.class.getName()});
        Assertions.assertEquals((Object)OpifyOp1.class.getName(), (Object)opifyOpInfo.implementationName());
        Assertions.assertEquals((double)0.0, (double)opifyOpInfo.priority(), (double)0.0);
    }

    @Test
    public void testClassOpificationWithPriority() {
        OpInfo opifyOpInfo = ops.opify(OpifyOp1.class, 100.0, new String[]{OpifyOp1.class.getName()});
        Assertions.assertEquals((Object)OpifyOp1.class.getName(), (Object)opifyOpInfo.implementationName());
        Assertions.assertEquals((double)100.0, (double)opifyOpInfo.priority(), (double)0.0);
    }

    @Test
    public void testRegister() {
        String opName = "test.opifyOp";
        OpInfo opifyOpInfo = ops.opify(OpifyOp1.class, 100.0, new String[]{opName});
        ops.register(new Object[]{opifyOpInfo});
        String actual = (String)ops.op(opName).outType(String.class).create();
        String expected = new OpifyOp1().getString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testHelpVerboseNoNS() {
        OpEnvironment helpEnv = this.makeHelpEnv("help.verbose1", "help.verbose2");
        String descriptions = helpEnv.helpVerbose();
        String expected = "Namespaces:\n\t> help";
        Assertions.assertEquals((Object)expected, (Object)descriptions);
    }

    @Test
    public void testHelpVerboseInvalid() {
        OpEnvironment helpEnv = this.makeHelpEnv("help.verbose1", "help.verbose2");
        String descriptions = helpEnv.helpVerbose("ichneumon");
        String expected = "Not a valid Op name or namespace:\n\t> ichneumon";
        Assertions.assertEquals((Object)expected, (Object)descriptions);
    }

    @Test
    public void testHelpVerboseNS() {
        OpEnvironment helpEnv = this.makeHelpEnv("help.verbose1", "help.verbose2");
        String descriptions = helpEnv.helpVerbose("help");
        String expected = "Names:\n\t> help.verbose1\n\t> help.verbose2";
        Assertions.assertEquals((Object)expected, (Object)descriptions);
    }

    @Test
    public void testHelpVerboseOp() {
        OpEnvironment helpEnv = this.makeHelpEnv("help.verbose1", "help.verbose2");
        String descriptions = helpEnv.helpVerbose("help.verbose1");
        String expected = "help.verbose1:\n\t- org.scijava.ops.engine.OpifyOp1\n\t\tReturns : java.lang.String";
        Assertions.assertEquals((Object)expected, (Object)descriptions);
    }

    @Test
    public void testHelpVerboseNotFound() {
        OpEnvironment helpEnv = this.makeHelpEnv("help.verbose1", "help.verbose2");
        String descriptions = helpEnv.op("help.verbose1").input(null).helpVerbose();
        String expected = "No Ops found matching this request.";
        Assertions.assertEquals((Object)expected, (Object)descriptions);
    }

    @Test
    public void testInternalNamespaceHelp() {
        OpEnvironment helpEnv = this.makeHelpEnv("engine.adapt", "help.verbose1");
        String actual = helpEnv.help();
        String expected = "Namespaces:\n\t> help";
        Assertions.assertEquals((Object)expected, (Object)actual);
        actual = helpEnv.help("engine.adapt");
        expected = "engine.adapt:\n\t- () -> String";
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private OpEnvironment makeHelpEnv(String n1, String n2) {
        OpEnvironment helpEnv = OpEnvironmentTest.barebonesEnvironment();
        helpEnv.register(new Object[]{helpEnv.opify(OpifyOp1.class, 100.0, new String[]{n1})});
        helpEnv.register(new Object[]{helpEnv.opify(OpifyOp2.class, 100.0, new String[]{n2})});
        return helpEnv;
    }
}

