/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine;

import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.function.Container;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.spi.Op;
import org.scijava.ops.spi.OpClass;
import org.scijava.ops.spi.OpCollection;

public class OpInfoTest
extends AbstractTestEnvironment
implements OpCollection {
    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new IntListAdder()});
        ops.register(new Object[]{new DoubleListAdder()});
    }

    @Test
    public void testOpInfoDescriptions() {
        Iterator infos = ops.infos("test.opinfo.listAdder").iterator();
        while (infos.hasNext()) {
            ((OpInfo)infos.next()).toString();
        }
    }

    @OpClass(names="test.opinfo.listAdder")
    public static class DoubleListAdder
    extends AbstractListAdder<Double> {
    }

    @OpClass(names="test.opinfo.listAdder")
    public static class IntListAdder
    extends AbstractListAdder<Integer> {
    }

    public static abstract class AbstractListAdder<T>
    implements Computers.Arity1<T, List<T>>,
    Op {
        public void compute(T in, @Container List<T> out) {
            out.add(in);
        }
    }
}

