/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.adapt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.spi.Op;
import org.scijava.ops.spi.OpClass;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpDependency;
import org.scijava.ops.spi.OpField;

public class AdaptationTypeVariableCaptureTest<N extends Number>
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.adaptedCapture")
    public final Computers.Arity1<List<N>, List<Double>> original = (in, out) -> {
        out.clear();
        for (Number n : in) {
            out.add(n.doubleValue());
        }
    };
    @OpField(names="engine.create", priority=100.0)
    public final Function<List<Byte>, List<Byte>> highCopier = list -> {
        throw new IllegalStateException("This Op should not be called");
    };
    @OpField(names="engine.create", priority=-100.0)
    public final Function<List<Byte>, List<Double>> lowCopier = list -> new ArrayList();

    @BeforeAll
    public static void AddNeededOps() {
        ops.register(new Object[]{new Computer1ToFunction1ViaFunction()});
        ops.register(new Object[]{new AdaptationTypeVariableCaptureTest()});
    }

    @Test
    public void testCapture() {
        List<Byte> in = Arrays.asList((byte)0, (byte)1);
        Object out = ops.op("test.adaptedCapture").input(in).apply();
        Assertions.assertInstanceOf(List.class, (Object)out);
        Assertions.assertEquals((int)2, (int)in.size());
    }

    @OpClass(names="engine.adapt")
    public static class Computer1ToFunction1ViaFunction<I, O>
    implements Function<Computers.Arity1<I, O>, Function<I, O>>,
    Op {
        @OpDependency(name="engine.create", hints={"adaptation.FORBIDDEN"})
        Function<I, O> creator;

        @Override
        public Function<I, O> apply(Computers.Arity1<I, O> computer) {
            return in -> {
                O out = this.creator.apply(in);
                computer.compute(in, out);
                return out;
            };
        }
    }
}

