/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.adapt;

import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.function.Producer;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpDependency;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpMethod;

public class OpAdaptationPriorityTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.priorityOp")
    public static final Computers.Arity1<Double, PriorityThing> priorityOp = (in, out) -> out.increasePriority((double)in);
    @OpField(names="engine.create")
    public static final Producer<PriorityThing> priorityThingProducer = () -> new PriorityThing(10000.0);
    @OpField(names="engine.create")
    public static final Function<Double, PriorityThing> priorityThingFunction = in -> new PriorityThing((double)in);

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new OpAdaptationPriorityTest()});
    }

    @OpMethod(names="engine.adapt", type=Function.class, priority=100.0)
    public static <I, O> Function<I, O> highPriorityAdaptor(@OpDependency(name="engine.create", hints={"adaptation.FORBIDDEN"}) Function<I, O> creator, Computers.Arity1<I, O> computer) {
        return in -> {
            Object out = creator.apply(in);
            computer.compute(in, out);
            return out;
        };
    }

    @OpMethod(names="engine.adapt", type=Function.class, priority=-100.0)
    public static <I, O> Function<I, O> lowPriorityAdaptor(@OpDependency(name="engine.create", hints={"adaptation.FORBIDDEN"}) Producer<O> creator, Computers.Arity1<I, O> computer) {
        return in -> {
            Object out = creator.get();
            computer.compute(in, out);
            return out;
        };
    }

    @Test
    public void testPriority() {
        PriorityThing pThing = (PriorityThing)ops.op("test.priorityOp").input((Object)10.0).outType(PriorityThing.class).apply();
        Assertions.assertEquals((double)20.0, (double)pThing.getPriority(), (double)0.0);
        Assertions.assertNotEquals((double)10010.0, (double)pThing.getPriority(), (double)0.0);
    }

    public static class PriorityThing {
        double priority;

        public PriorityThing(double priority) {
            this.priority = priority;
        }

        public void increasePriority(double newPriority) {
            this.priority += newPriority;
        }

        public double getPriority() {
            return this.priority;
        }
    }
}

