/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.hints;

import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.adapt.functional.FunctionsToComputers;
import org.scijava.ops.engine.copy.CopyOpCollection;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpHints;

public class AdaptationHintTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.adaptation.hints")
    public final Function<Double[], Double[]> op = in -> new Double[((Double[])in).length];
    @OpHints(hints={"adaptation.FORBIDDEN"})
    @OpField(names="test.adaptation.unadaptable")
    public final Function<Double[], Double[]> nonAdaptableOp = in -> new Double[((Double[])in).length];

    @BeforeAll
    public static void AddNeededOps() {
        ops.register(new Object[]{new AdaptationHintTest()});
        ops.register(new Object[]{new FunctionsToComputers.Function1ToComputer1()});
        ops.register(new Object[]{new CopyOpCollection()});
    }

    @Test
    public void testAdaptation() {
        Hints hints = new Hints(new String[0]);
        ops.setDefaultHints(hints);
        Computers.Arity1 adaptable = ops.op("test.adaptation.hints").inType(Double[].class).outType(Double[].class).computer();
        hints = hints.plus(new String[]{"adaptation.FORBIDDEN"});
        ops.setDefaultHints(hints);
        try {
            ops.op("test.adaptation.hints").inType(Double[].class).outType(Double[].class).computer();
            throw new IllegalStateException("This op call should not match!");
        }
        catch (OpMatchingException opMatchingException) {
            return;
        }
    }

    @Test
    public void testAdaptationPerCallHints() {
        Hints hints = new Hints(new String[0]);
        Computers.Arity1 adaptable = ops.op("test.adaptation.hints", hints).inType(Double[].class).outType(Double[].class).computer();
        hints = hints.plus(new String[]{"adaptation.FORBIDDEN"});
        try {
            ops.op("test.adaptation.hints", hints).inType(Double[].class).outType(Double[].class).computer();
            throw new IllegalStateException("This op call should not match!");
        }
        catch (OpMatchingException opMatchingException) {
            return;
        }
    }

    @Test
    public void testNonAdaptableOp() {
        Hints hints = new Hints(new String[0]);
        ops.setDefaultHints(hints);
        Function adaptable = ops.op("test.adaptation.unadaptable").inType(Double[].class).outType(Double[].class).function();
        try {
            ops.op("test.adaptation.unadaptable").inType(Double[].class).outType(Double[].class).computer();
            throw new IllegalStateException("This op call should not match!");
        }
        catch (OpMatchingException opMatchingException) {
            return;
        }
    }

    @Test
    public void testNonAdaptableOpPerCallHints() {
        Hints hints = new Hints(new String[0]);
        Function adaptable = ops.op("test.adaptation.unadaptable", hints).inType(Double[].class).outType(Double[].class).function();
        Assertions.assertThrows(OpMatchingException.class, () -> ops.op("test.adaptation.unadaptable", hints).inType(Double[].class).outType(Double[].class).computer(), (String)"This op call should not match!");
    }
}

