/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.hints;

import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.conversionLoss.impl.IdentityLossReporter;
import org.scijava.ops.engine.matcher.convert.IdentityCollection;
import org.scijava.ops.engine.matcher.convert.PrimitiveArrayConverters;
import org.scijava.ops.engine.matcher.convert.UtilityConverters;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpHints;

public class ConversionHintTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.conversion.hints")
    public final Function<Double[], Double[]> op = in -> new Double[((Double[])in).length];
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="test.conversion.nonconvertible")
    public final Function<Double[], Double[]> nonAdaptableOp = in -> new Double[((Double[])in).length];

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new ConversionHintTest()});
        ops.register(new Object[]{new IdentityCollection()});
        ops.register(new Object[]{new IdentityLossReporter()});
        ops.register(new Object[]{new UtilityConverters()});
        ops.register(new Object[]{new PrimitiveArrayConverters()});
    }

    @Test
    public void testConversion() {
        Hints hints = new Hints(new String[0]);
        ops.setDefaultHints(hints);
        Function adaptable = ops.op("test.conversion.hints").inType(Integer[].class).outType(Integer[].class).function();
        hints = hints.plus(new String[]{"conversion.FORBIDDEN"});
        ops.setDefaultHints(hints);
        Assertions.assertThrows(OpMatchingException.class, () -> ops.op("test.conversion.hints").inType(Integer[].class).outType(Integer[].class).function(), (String)"Conversion is forbidden - this op call should not match!");
    }

    @Test
    public void testConversionPerCallHints() {
        Hints hints = new Hints(new String[0]);
        Function adaptable = ops.op("test.conversion.hints", hints).inType(Integer[].class).outType(Integer[].class).function();
        Hints forbid = hints.plus(new String[]{"conversion.FORBIDDEN"});
        Assertions.assertThrows(OpMatchingException.class, () -> ops.op("test.conversion.hints", forbid).inType(Integer[].class).outType(Integer[].class).function(), (String)"Conversion is forbidden - this op call should not match!");
    }

    @Test
    public void testNonconvertibleOp() {
        Hints hints = new Hints(new String[0]);
        ops.setDefaultHints(hints);
        Function adaptable = ops.op("test.conversion.nonconvertible").inType(Double[].class).outType(Double[].class).function();
        Assertions.assertThrows(OpMatchingException.class, () -> ops.op("test.conversion.nonconvertible").inType(Integer[].class).outType(Integer[].class).function(), (String)"The only relevant Op is not convertible - this op call should not match!");
    }

    @Test
    public void testNonconvertibleOpPerCallHints() {
        Hints hints = new Hints(new String[0]);
        Function adaptable = ops.op("test.conversion.nonconvertible", hints).inType(Double[].class).outType(Double[].class).function();
        Assertions.assertThrows(OpMatchingException.class, () -> ops.op("test.conversion.nonconvertible", hints).inType(Integer[].class).outType(Integer[].class).function(), (String)"The only relevant Op is not convertible - this op call should not match!");
    }
}

