/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.impl;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.function.Inplaces;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.describe.BaseDescriptors;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;

public class DefaultOpDescriptionGeneratorTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.coalesceDescription")
    public final Function<Double, Double> func1 = in -> in + 1.0;
    @OpField(names="test.coalesceDescription")
    public final Function<Long, Long> func2 = in -> in + 1L;
    @OpField(names="test.coalesceDescription")
    public final Computers.Arity1<List<Long>, List<Long>> comp1 = (in, out) -> {
        out.clear();
        out.addAll(in);
    };
    @OpField(names="test.coalesceDescription")
    public final Inplaces.Arity2_1<List<Long>, Long> inplace1 = (in1, in2) -> {
        in1.clear();
        in1.add(in2);
    };
    private static final String TEST_DESC = "Adds two integers";
    @OpField(names="math.add", description="Adds two integers")
    public final BiFunction<Integer, Integer, Integer> functionAdder = Integer::sum;

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new DefaultOpDescriptionGeneratorTest(), new BaseDescriptors()});
    }

    @Test
    public void testCoalescedDescriptions() {
        String actual = ops.op("test.coalesceDescription").helpVerbose();
        String expected = "test.coalesceDescription:\n\t- org.scijava.ops.engine.impl.DefaultOpDescriptionGeneratorTest$comp1\n\t\t> input1 : java.util.List<java.lang.Long>\n\t\t> container1 : @CONTAINER java.util.List<java.lang.Long>\n\t- org.scijava.ops.engine.impl.DefaultOpDescriptionGeneratorTest$func1\n\t\t> input1 : java.lang.Double\n\t\tReturns : java.lang.Double\n\t- org.scijava.ops.engine.impl.DefaultOpDescriptionGeneratorTest$func2\n\t\t> input1 : java.lang.Long\n\t\tReturns : java.lang.Long\n\t- org.scijava.ops.engine.impl.DefaultOpDescriptionGeneratorTest$inplace1\n\t\t> mutable1 : @MUTABLE java.util.List<java.lang.Long>\n\t\t> input1 : java.lang.Long";
        Assertions.assertEquals((Object)expected, (Object)actual);
        actual = ops.op("test.coalesceDescription").help();
        expected = "test.coalesceDescription:\n\t- (list<number>, @CONTAINER list<number>) -> None\n\t- (number) -> number\n\t- (@MUTABLE list<number>, number) -> None";
        Assertions.assertEquals((Object)expected, (Object)actual);
        actual = ops.op("test.coalesceDescription").input(null, null).help();
        expected = "test.coalesceDescription:\n\t- (@MUTABLE list<number>, number) -> None";
        Assertions.assertEquals((Object)expected, (Object)actual);
        actual = ops.op("test.coalesceDescription").output(null).help();
        expected = "No Ops found matching this request.";
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDescriptionWithDescription() {
        String actual = ops.op("math.add").helpVerbose();
        String expected = "math.add:\n\t- org.scijava.ops.engine.impl.DefaultOpDescriptionGeneratorTest$functionAdder\n\t\tAdds two integers\n\t\t> input1 : java.lang.Integer\n\t\t> input2 : java.lang.Integer\n\t\tReturns : java.lang.Integer";
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

