/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.api.Hints;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.exceptions.impl.OpDependencyPositionException;
import org.scijava.ops.engine.matcher.impl.DefaultOpMethodInfo;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpDependency;

public class OpMethodDependencyPositionTest
extends AbstractTestEnvironment
implements OpCollection {
    public static void goodDep(@OpDependency(name="someDep") Function<String, Long> op, List<String> in, List<Long> out) {
        out.clear();
        for (String s : in) {
            out.add(op.apply(s));
        }
    }

    @Test
    public void testOpDependencyBefore() throws NoSuchMethodException {
        Method m = this.getClass().getDeclaredMethod("goodDep", Function.class, List.class, List.class);
        Assertions.assertDoesNotThrow(() -> new DefaultOpMethodInfo(m, Computers.Arity1.class, "1.0", "", new Hints(new String[0]), 1.0, new String[]{"test.dependencyBeforeInput"}));
    }

    public static void badDep(List<String> in, @OpDependency(name="someDep") Function<String, Long> op, List<Long> out) {
        out.clear();
        for (String s : in) {
            out.add(op.apply(s));
        }
    }

    @Test
    public void testOpDependencyAfter() throws NoSuchMethodException {
        Method m = this.getClass().getDeclaredMethod("badDep", List.class, Function.class, List.class);
        this.createInvalidInfo(m, Computers.Arity1.class, "test.dependencyAfterInput");
    }

    public static void goodThenBadDep(@OpDependency(name="someDep") Function<String, Long> op, List<String> in, @OpDependency(name="someOtherDep") Function<String, Long> op2, List<Long> out) {
        out.clear();
        for (String s : in) {
            out.add(op.apply(s));
        }
    }

    @Test
    public void testOpDependencyBeforeAndAfter() throws NoSuchMethodException {
        Method m = this.getClass().getDeclaredMethod("goodThenBadDep", Function.class, List.class, Function.class, List.class);
        this.createInvalidInfo(m, Computers.Arity1.class, "test.dependencyBeforeAndAfterInput");
    }

    private void createInvalidInfo(Method m, Class<?> arity, String ... names) {
        Assertions.assertThrows(OpDependencyPositionException.class, () -> new DefaultOpMethodInfo(m, arity, "1.0", "", new Hints(new String[0]), 1.0, names));
    }
}

