/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.types.Nil;

public class MatchingWithGCSTTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.listTypeReification")
    public static final Function<List<? extends Thing>, List<Double>> fooOP = in -> {
        ArrayList<Double> returnList = new ArrayList<Double>();
        returnList.add(0.0);
        return returnList;
    };

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new MatchingWithGCSTTest()});
    }

    @Test
    public void testAddOpMatchingIntegration() {
        ArrayList<Object> things = new ArrayList<Object>();
        things.add(new NThing());
        things.add(new XThing());
        things.add(new YThing());
        List<Double> actual = fooOP.apply(things);
        List expected = (List)ops.op("test.listTypeReification").input(things).outType((Nil)new Nil<List<Double>>(){}).apply();
        Assertions.assertEquals((Object)expected, actual);
    }

    static class YThing
    implements Thing {
        YThing() {
        }
    }

    static class QThing
    extends YThing
    implements Stuff {
        QThing() {
        }
    }

    static class NThing
    extends Base
    implements Thing,
    Stuff {
        NThing() {
        }
    }

    static class Base {
        Base() {
        }
    }

    static class XThing
    extends Base
    implements Thing {
        XThing() {
        }
    }

    static interface Stuff {
    }

    static interface Thing {
    }
}

