/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher;

import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.DependencyMatchingException;
import org.scijava.ops.engine.adapt.functional.ComputersToFunctionsViaFunction;
import org.scijava.ops.engine.create.CreateOpCollection;
import org.scijava.ops.engine.matcher.DependentOp;
import org.scijava.ops.engine.matcher.FurtherDependentOp;
import org.scijava.ops.engine.matcher.MissingDependencyOp;
import org.scijava.ops.engine.matcher.MissingDependencyOpArr1;
import org.scijava.ops.engine.matcher.MissingDependencyOpArr2;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;

public class OpMatchingExceptionTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.duplicateOp")
    public final Function<Double, Double> duplicateA = in -> in;
    @OpField(names="test.duplicateOp")
    public final Function<Double, Double> duplicateB = in -> in;

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new OpMatchingExceptionTest()});
        ops.register(new Object[]{new DependentOp()});
        ops.register(new Object[]{new FurtherDependentOp()});
        ops.register(new Object[]{new MissingDependencyOp()});
        ops.register(new Object[]{new MissingDependencyOpArr1()});
        ops.register(new Object[]{new MissingDependencyOpArr2()});
        ops.register(new Object[]{new ComputersToFunctionsViaFunction.Computer1ToFunction1ViaFunction()});
        ops.register(new Object[]{new CreateOpCollection()});
    }

    @Test
    public void testDuplicateErrorRegression() {
        try {
            ops.op("test.duplicateOp").inType(Double.class).outType(Double.class).function();
            Assertions.fail();
        }
        catch (OpMatchingException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Multiple ops of equal priority detected for request"));
            Assertions.assertTrue((boolean)e.getMessage().contains("test.duplicateOp"));
        }
    }

    @Test
    public void testMissingDependencyRegression() {
        try {
            ops.op("test.missingDependencyOp").input((Object)1.0).outType(Double.class).apply();
            Assertions.fail((String)"Expected DependencyMatchingException");
        }
        catch (DependencyMatchingException e) {
            String message = e.getMessage();
            Assertions.assertTrue((boolean)message.contains("Name: \"test.missingDependencyOp\""));
        }
    }

    @Test
    public void testMissingNestedDependencyRegression() {
        try {
            ops.op("test.outsideOp").input((Object)1.0).outType(Double.class).apply();
            Assertions.fail((String)"Expected DependencyMatchingException");
        }
        catch (DependencyMatchingException e) {
            String message = e.getMessage();
            Assertions.assertTrue((boolean)message.contains("Name: \"test.outsideOp\""));
        }
    }

    @Test
    public void testMissingDependencyViaAdaptation() {
        Double[] d = new Double[]{};
        try {
            ops.op("test.adaptMissingDep").input((Object)d).outType(Double[].class).apply();
            Assertions.fail((String)"Expected DependencyMatchingException");
        }
        catch (DependencyMatchingException e) {
            String message = e.getMessage();
            Assertions.assertTrue((boolean)message.contains("Name: \"test.adaptMissingDep\""));
        }
    }
}

