/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.adapt;

import java.util.function.BiFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.Ops;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.adapt.functional.FunctionsToComputers;
import org.scijava.ops.engine.copy.CopyOpCollection;
import org.scijava.ops.engine.matcher.adapt.OpAdaptationInfo;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpMethod;

public class OpAdaptationInfoTest
extends AbstractTestEnvironment
implements OpCollection {
    private static final String TEST_DESC = "This is an Op that is being adapted";

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new OpAdaptationInfoTest()});
        ops.register(new Object[]{new CopyOpCollection()});
        ops.register(new Object[]{new FunctionsToComputers.Function2ToComputer2()});
    }

    @OpMethod(names="test.adaptationDescription", type=BiFunction.class, description="This is an Op that is being adapted")
    public static double[] adaptableOp(Double t, Double u) {
        return new double[]{t, u};
    }

    @Test
    public void testAdaptedDescription() {
        Computers.Arity2 adapted = ops.op("test.adaptationDescription").inType(Double.class, Double.class).outType(double[].class).computer();
        OpInfo info = Ops.info((Object)adapted);
        Assertions.assertInstanceOf(OpAdaptationInfo.class, (Object)info);
        Assertions.assertEquals((Object)TEST_DESC, (Object)info.description());
        String expected = "org.scijava.ops.engine.matcher.adapt.OpAdaptationInfoTest.adaptableOp(java.lang.Double,java.lang.Double)\n\tAdaptor: org.scijava.ops.engine.adapt.functional.FunctionsToComputers$Function2ToComputer2\n\t\tDepends upon: org.scijava.ops.engine.copy.CopyOpCollection$copyDoubleArray\n\tThis is an Op that is being adapted\n\t> input1 : java.lang.Double\n\t> input2 : java.lang.Double\n\t> output1 : @CONTAINER double[]";
        String actual = adapted.toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

