/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.conversionLoss.LossReporter;
import org.scijava.ops.engine.conversionLoss.impl.IdentityLossReporter;
import org.scijava.ops.engine.matcher.convert.IdentityCollection;
import org.scijava.ops.engine.matcher.impl.LossReporterWrapper;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpHints;

public class ConversionPriorityTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<FromThing, BasicThing> fromToBasic = from -> new BasicThing();
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<FromThing, LosslessThing> basicToLossless = basic -> new LosslessThing();
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<FromThing, SomewhatLossyThing> basicToSomewhat = basic -> new SomewhatLossyThing();
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<FromThing, VeryLossyThing> basicToVery = basic -> new VeryLossyThing();
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<FromThing, InconceivablyLossyThing> basicToInconceivable = basic -> new InconceivablyLossyThing();
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.lossReporter")
    public final LossReporter<FromThing, LosslessThing> fromToLossless = (nil1, nil2) -> 1.0;
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.lossReporter")
    public final LossReporter<FromThing, SomewhatLossyThing> fromToSomewhat = (nil1, nil2) -> 1000.0;
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.lossReporter")
    public final LossReporter<FromThing, VeryLossyThing> fromToVery = (nil1, nil2) -> 1000000.0;
    @OpField(names="test.thing")
    public final BiFunction<LosslessThing, VeryLossyThing, Double> thingBiFunc1 = (in1, in2) -> 0.0;
    @OpField(names="test.thing")
    public final BiFunction<SomewhatLossyThing, SomewhatLossyThing, Double> thingBiFunc2 = (in1, in2) -> 1.0;
    @OpField(names="test.thing")
    public final Function<SomewhatLossyThing, Double> thingFunc1 = in1 -> 2.0;
    @OpField(names="test.thing")
    public final Function<InconceivablyLossyThing, Double> thingFunc2 = in1 -> 3.0;

    @BeforeAll
    public static void AddNeededOps() {
        ops.register(new Object[]{new ConversionPriorityTest()});
        ops.register(new Object[]{new IdentityLossReporter()});
        ops.register(new Object[]{new IdentityCollection()});
        ops.register(new Object[]{new LossReporterWrapper()});
    }

    @Test
    public void testConversionPriority() {
        FromThing thing1 = new FromThing();
        FromThing thing2 = new FromThing();
        Double output = (Double)ops.op("test.thing").input((Object)thing1, (Object)thing2).outType(Double.class).apply();
        Assertions.assertEquals((double)1.0, (double)output, (double)0.0);
    }

    @Test
    public void testMissingLossReporter() {
        FromThing thing1 = new FromThing();
        Double output = (Double)ops.op("test.thing").input((Object)thing1).outType(Double.class).apply();
        Assertions.assertEquals((double)2.0, (double)output, (double)0.0);
    }

    class InconceivablyLossyThing {
        InconceivablyLossyThing() {
        }
    }

    class VeryLossyThing {
        VeryLossyThing() {
        }
    }

    class SomewhatLossyThing {
        SomewhatLossyThing() {
        }
    }

    class LosslessThing {
        LosslessThing() {
        }
    }

    class BasicThing {
        BasicThing() {
        }
    }

    class FromThing {
        FromThing() {
        }
    }
}

