/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.conversionLoss.impl.IdentityLossReporter;
import org.scijava.ops.engine.conversionLoss.impl.PrimitiveLossReporters;
import org.scijava.ops.engine.matcher.convert.IdentityCollection;
import org.scijava.ops.engine.matcher.convert.PrimitiveArrayConverters;
import org.scijava.ops.engine.matcher.convert.UtilityConverters;
import org.scijava.ops.engine.matcher.impl.LossReporterWrapper;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;

public class PrimitiveArrayConverterTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.byteArray")
    public final Function<Double[], Double[]> byteArray = in -> {
        Double[] d = new Double[((Double[])in).length];
        for (int i = 0; i < ((Double[])in).length; ++i) {
            d[i] = in[i] + 1.0;
        }
        return d;
    };
    @OpField(names="test.bytePrimitiveArray")
    public final Function<Double[], Double[]> bytePrimitiveArray = in -> {
        Double[] d = new Double[((Double[])in).length];
        for (int i = 0; i < ((Double[])in).length; ++i) {
            d[i] = in[i] + 1.0;
        }
        return d;
    };
    @OpField(names="test.shortArray")
    public final Function<Double[], Double[]> shortArray = in -> {
        Double[] d = new Double[((Double[])in).length];
        for (int i = 0; i < ((Double[])in).length; ++i) {
            d[i] = in[i] + 1.0;
        }
        return d;
    };
    @OpField(names="test.shortPrimitiveArray")
    public final Function<Double[], Double[]> shortPrimitiveArray = in -> {
        Double[] d = new Double[((Double[])in).length];
        for (int i = 0; i < ((Double[])in).length; ++i) {
            d[i] = in[i] + 1.0;
        }
        return d;
    };
    @OpField(names="test.intArray")
    public final Function<Double[], Double[]> intArray = in -> {
        Double[] d = new Double[((Double[])in).length];
        for (int i = 0; i < ((Double[])in).length; ++i) {
            d[i] = in[i] + 1.0;
        }
        return d;
    };
    @OpField(names="test.intPrimitiveArray")
    public final Function<Double[], Double[]> intPrimitiveArray = in -> {
        Double[] d = new Double[((Double[])in).length];
        for (int i = 0; i < ((Double[])in).length; ++i) {
            d[i] = in[i] + 1.0;
        }
        return d;
    };
    @OpField(names="test.longArray")
    public final Function<Double[], Double[]> longArray = in -> {
        Double[] d = new Double[((Double[])in).length];
        for (int i = 0; i < ((Double[])in).length; ++i) {
            d[i] = in[i] + 1.0;
        }
        return d;
    };
    @OpField(names="test.longPrimitiveArray")
    public final Function<Double[], Double[]> longPrimitiveArray = in -> {
        Double[] d = new Double[((Double[])in).length];
        for (int i = 0; i < ((Double[])in).length; ++i) {
            d[i] = in[i] + 1.0;
        }
        return d;
    };
    @OpField(names="test.floatArray")
    public final Function<Integer[], Integer[]> floatArray = in -> {
        Integer[] d = new Integer[((Integer[])in).length];
        for (int i = 0; i < ((Integer[])in).length; ++i) {
            d[i] = in[i] + 1;
        }
        return d;
    };
    @OpField(names="test.floatPrimitiveArray")
    public final Function<Integer[], Integer[]> floatPrimitiveArray = in -> {
        Integer[] d = new Integer[((Integer[])in).length];
        for (int i = 0; i < ((Integer[])in).length; ++i) {
            d[i] = in[i] + 1;
        }
        return d;
    };
    @OpField(names="test.doubleArray")
    public final Function<Integer[], Integer[]> doubleArray = in -> {
        Integer[] d = new Integer[((Integer[])in).length];
        for (int i = 0; i < ((Integer[])in).length; ++i) {
            d[i] = in[i] + 1;
        }
        return d;
    };
    @OpField(names="test.doublePrimitiveArray")
    public final Function<Integer[], Integer[]> doublePrimitiveArray = in -> {
        Integer[] d = new Integer[((Integer[])in).length];
        for (int i = 0; i < ((Integer[])in).length; ++i) {
            d[i] = in[i] + 1;
        }
        return d;
    };

    @BeforeAll
    public static void AddNeededOps() {
        ops.register(new Object[]{new PrimitiveArrayConverterTest(), new UtilityConverters(), new PrimitiveLossReporters(), new IdentityLossReporter(), new IdentityCollection(), new LossReporterWrapper(), new PrimitiveArrayConverters()});
    }

    @Test
    public void testByteArray() {
        Byte[] original = new Byte[]{(byte)1, (byte)2};
        Object[] actual = (Byte[])ops.op("test.byteArray").input((Object)original).outType(Byte[].class).apply();
        Object[] expected = new Byte[]{(byte)2, (byte)3};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testBytePrimitiveArray() {
        byte[] original = new byte[]{1, 2};
        byte[] actual = (byte[])ops.op("test.bytePrimitiveArray").input((Object)original).outType(byte[].class).apply();
        byte[] expected = new byte[]{2, 3};
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testShortArray() {
        Short[] original = new Short[]{(short)1, (short)2};
        Object[] actual = (Short[])ops.op("test.shortArray").input((Object)original).outType(Short[].class).apply();
        Object[] expected = new Short[]{(short)2, (short)3};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testShortPrimitiveArray() {
        short[] original = new short[]{1, 2};
        short[] actual = (short[])ops.op("test.shortPrimitiveArray").input((Object)original).outType(short[].class).apply();
        short[] expected = new short[]{2, 3};
        Assertions.assertArrayEquals((short[])expected, (short[])actual);
    }

    @Test
    public void testIntegerArray() {
        Integer[] original = new Integer[]{1, 2};
        Object[] actual = (Integer[])ops.op("test.intArray").input((Object)original).outType(Integer[].class).apply();
        Object[] expected = new Integer[]{2, 3};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testIntegerPrimitiveArray() {
        int[] original = new int[]{1, 2};
        int[] actual = (int[])ops.op("test.intPrimitiveArray").input((Object)original).outType(int[].class).apply();
        int[] expected = new int[]{2, 3};
        Assertions.assertArrayEquals((int[])expected, (int[])actual);
    }

    @Test
    public void testLongArray() {
        Long[] original = new Long[]{1L, 2L};
        Object[] actual = (Long[])ops.op("test.longArray").input((Object)original).outType(Long[].class).apply();
        Object[] expected = new Long[]{2L, 3L};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testLongPrimitiveArray() {
        long[] original = new long[]{1L, 2L};
        long[] actual = (long[])ops.op("test.longPrimitiveArray").input((Object)original).outType(long[].class).apply();
        long[] expected = new long[]{2L, 3L};
        Assertions.assertArrayEquals((long[])expected, (long[])actual);
    }

    @Test
    public void testFloatArray() {
        Float[] original = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)};
        Object[] actual = (Float[])ops.op("test.floatArray").input((Object)original).outType(Float[].class).apply();
        Object[] expected = new Float[]{Float.valueOf(2.0f), Float.valueOf(3.0f)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testFloatPrimitiveArray() {
        float[] original = new float[]{1.0f, 2.0f};
        float[] actual = (float[])ops.op("test.floatPrimitiveArray").input((Object)original).outType(float[].class).apply();
        float[] expected = new float[]{2.0f, 3.0f};
        Assertions.assertArrayEquals((float[])expected, (float[])actual);
    }

    @Test
    public void testDoubleArray() {
        Double[] original = new Double[]{1.0, 2.0};
        Object[] actual = (Double[])ops.op("test.doubleArray").input((Object)original).outType(Double[].class).apply();
        Object[] expected = new Double[]{2.0, 3.0};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testDoublePrimitiveArray() {
        double[] original = new double[]{1.0, 2.0};
        double[] actual = (double[])ops.op("test.doublePrimitiveArray").input((Object)original).outType(double[].class).apply();
        double[] expected = new double[]{2.0, 3.0};
        Assertions.assertArrayEquals((double[])expected, (double[])actual);
    }
}

