/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.impl;

import java.lang.reflect.Method;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.function.Producer;
import org.scijava.ops.api.Hints;
import org.scijava.ops.engine.exceptions.impl.FunctionalTypeOpException;
import org.scijava.ops.engine.exceptions.impl.InstanceOpMethodException;
import org.scijava.ops.engine.exceptions.impl.PrivateOpException;
import org.scijava.ops.engine.matcher.impl.DefaultOpMethodInfo;

public class OpMethodInfoTest {
    private static Boolean privateOp() {
        return true;
    }

    @Test
    public void testPrivateMethod() throws NoSuchMethodException {
        Method m = this.getClass().getDeclaredMethod("privateOp", new Class[0]);
        Assertions.assertThrows(PrivateOpException.class, () -> new DefaultOpMethodInfo(m, Producer.class, "1.0", "", new Hints(new String[0]), 1.0, new String[]{"privateOp"}));
    }

    public Boolean instanceOp() {
        return true;
    }

    @Test
    public void testInstanceMethod() throws NoSuchMethodException {
        Method m = this.getClass().getDeclaredMethod("instanceOp", new Class[0]);
        Assertions.assertThrows(InstanceOpMethodException.class, () -> new DefaultOpMethodInfo(m, Producer.class, "1.0", "", new Hints(new String[0]), 1.0, new String[]{"instanceOp"}));
    }

    public static Boolean staticOp() {
        return true;
    }

    @Test
    public void testNonFuncIFace() throws NoSuchMethodException {
        Method m = this.getClass().getDeclaredMethod("staticOp", new Class[0]);
        Assertions.assertThrows(FunctionalTypeOpException.class, () -> new DefaultOpMethodInfo(m, this.getClass(), "1.0", "", new Hints(new String[0]), 1.0, new String[]{"staticOp"}));
    }

    @Test
    public void testWrongOpType() throws NoSuchMethodException {
        Method m = this.getClass().getDeclaredMethod("staticOp", new Class[0]);
        Assertions.assertThrows(FunctionalTypeOpException.class, () -> new DefaultOpMethodInfo(m, Function.class, "1.0", "", new Hints(new String[0]), 1.0, new String[]{"staticOp"}));
    }

    public static void mutateDouble(Double input, Double io) {
    }

    @Test
    public void testImmutableOutput() throws NoSuchMethodException {
        Method m = this.getClass().getDeclaredMethod("mutateDouble", Double.class, Double.class);
        Assertions.assertThrows(FunctionalTypeOpException.class, () -> new DefaultOpMethodInfo(m, Computers.Arity1.class, "1.0", "", new Hints(new String[0]), 1.0, new String[]{"mutateDouble"}));
    }
}

