/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.util;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.math.Add;
import org.scijava.ops.engine.math.Power;
import org.scijava.ops.engine.math.Sqrt;
import org.scijava.types.Nil;

public class FunctionsTest
extends AbstractTestEnvironment {
    private static Nil<Double> nilDouble = new Nil<Double>(){};

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new Sqrt()});
        ops.register(new Object[]{new Add()});
        ops.register(new Object[]{new Power()});
    }

    @Test
    public void testUnaryFunctions() {
        Function sqrtFunction = OpBuilder.matchFunction((OpEnvironment)ops, (String)"math.sqrt", nilDouble, nilDouble);
        double answer = (Double)sqrtFunction.apply(16.0);
        assert (4.0 == answer);
    }

    @Test
    public void testBinaryFunctions() {
        BiFunction addFunction = OpBuilder.matchFunction((OpEnvironment)ops, (String)"math.add", nilDouble, nilDouble, nilDouble);
        double answer = (Double)addFunction.apply(16.0, 14.0);
        assert (30.0 == answer);
        BiFunction powerFunction = OpBuilder.matchFunction((OpEnvironment)ops, (String)"math.pow", nilDouble, nilDouble, nilDouble);
        answer = (Double)powerFunction.apply(2.0, 10.0);
        assert (1024.0 == answer);
    }
}

