/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.function.Inplaces;
import org.scijava.ops.engine.util.Lambdas;

public class LambdaizerTest {
    public static void computer(String in, long[] out) {
        out[0] = in.length();
    }

    @Test
    public void testComputer() throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType methodTypeFunction = MethodType.methodType(Void.TYPE, String.class, long[].class);
        MethodHandle functionHandle = lookup.findStatic(LambdaizerTest.class, "computer", methodTypeFunction);
        Computers.Arity1 dynamicComputer = (Computers.Arity1)Lambdas.lambdaize(Computers.Arity1.class, (MethodHandle)functionHandle);
        String input = "four";
        long[] output = new long[]{0L};
        dynamicComputer.accept((Object)input, (Object)output);
        assert (output[0] == 4L);
    }

    public static void biComputer(String in1, String in2, long[] out) {
        out[0] = in1.length() + in2.length();
    }

    @Test
    public void testComputer2() throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType methodTypeFunction = MethodType.methodType(Void.TYPE, String.class, String.class, long[].class);
        MethodHandle functionHandle = lookup.findStatic(LambdaizerTest.class, "biComputer", methodTypeFunction);
        Computers.Arity2 dynamicComputer = (Computers.Arity2)Lambdas.lambdaize(Computers.Arity2.class, (MethodHandle)functionHandle);
        String input = "four";
        String input2 = "four";
        long[] output = new long[]{0L};
        dynamicComputer.accept((Object)input, (Object)input2, (Object)output);
        assert (output[0] == 8L);
    }

    public static void computer3(String in1, String in2, String in3, long[] out) {
        out[0] = in1.length() + in2.length() + in3.length();
    }

    @Test
    public void testComputer3() throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType methodTypeFunction = MethodType.methodType(Void.TYPE, String.class, String.class, String.class, long[].class);
        MethodHandle functionHandle = lookup.findStatic(LambdaizerTest.class, "computer3", methodTypeFunction);
        Computers.Arity3 dynamicComputer = (Computers.Arity3)Lambdas.lambdaize(Computers.Arity3.class, (MethodHandle)functionHandle);
        String input = "four";
        String input2 = "four";
        String input3 = "four";
        long[] output = new long[]{0L};
        dynamicComputer.accept((Object)input, (Object)input2, (Object)input3, (Object)output);
        assert (output[0] == 12L);
        dynamicComputer.compute((Object)input, (Object)input2, (Object)input3, (Object)output);
    }

    public static long[] function(String in) {
        long[] result = new long[]{0L};
        result[0] = in.length();
        return result;
    }

    @Test
    public void testFunction() throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType methodTypeFunction = MethodType.methodType(long[].class, String.class);
        MethodHandle functionHandle = lookup.findStatic(LambdaizerTest.class, "function", methodTypeFunction);
        Function dynamicFunction = (Function)Lambdas.lambdaize(Function.class, (MethodHandle)functionHandle);
        String input = "four";
        long[] output = (long[])dynamicFunction.apply(input);
        assert (output[0] == 4L);
    }

    public static long[] biFunction(String in, String in2) {
        long[] result = new long[]{0L};
        result[0] = in.length() + in2.length();
        return result;
    }

    @Test
    public void testBiFunction() throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType methodTypeFunction = MethodType.methodType(long[].class, String.class, String.class);
        MethodHandle functionHandle = lookup.findStatic(LambdaizerTest.class, "biFunction", methodTypeFunction);
        BiFunction dynamicFunction = (BiFunction)Lambdas.lambdaize(BiFunction.class, (MethodHandle)functionHandle);
        String input = "four";
        String input2 = "four";
        long[] output = (long[])dynamicFunction.apply(input, input2);
        assert (output[0] == 8L);
    }

    public static void inplace(long[] io) {
        int i = 0;
        while (i < io.length) {
            int n = i++;
            io[n] = io[n] * 2L;
        }
    }

    @Test
    public void testInplace() throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType methodTypeFunction = MethodType.methodType(Void.TYPE, long[].class);
        MethodHandle functionHandle = lookup.findStatic(LambdaizerTest.class, "inplace", methodTypeFunction);
        Inplaces.Arity1 dynamicFunction = (Inplaces.Arity1)Lambdas.lambdaize(Inplaces.Arity1.class, (MethodHandle)functionHandle);
        long[] io = new long[]{1L, 2L, 3L};
        long[] expected = new long[]{2L, 4L, 6L};
        dynamicFunction.mutate((Object)io);
        for (int i = 0; i < io.length; ++i) {
            assert (io[i] == expected[i]);
        }
    }

    public static void biInplaceFirst(long[] io, long[] i2) {
        for (int i = 0; i < io.length; ++i) {
            int n = i;
            io[n] = io[n] + i2[i];
        }
    }

    @Test
    public void testInplace2_1() throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType methodTypeFunction = MethodType.methodType(Void.TYPE, long[].class, long[].class);
        MethodHandle functionHandle = lookup.findStatic(LambdaizerTest.class, "biInplaceFirst", methodTypeFunction);
        Inplaces.Arity2_1 dynamicFunction = (Inplaces.Arity2_1)Lambdas.lambdaize(Inplaces.Arity2_1.class, (MethodHandle)functionHandle);
        long[] io = new long[]{1L, 2L, 3L};
        long[] i2 = new long[]{3L, 6L, 9L};
        long[] expected = new long[]{4L, 8L, 12L};
        dynamicFunction.mutate((Object)io, (Object)i2);
        for (int i = 0; i < io.length; ++i) {
            assert (io[i] == expected[i]);
        }
    }

    public static void biInplaceSecond(long[] i1, long[] io) {
        for (int i = 0; i < io.length; ++i) {
            int n = i;
            io[n] = io[n] + i1[i];
        }
    }

    @Test
    public void testInplace2_2() throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType methodTypeFunction = MethodType.methodType(Void.TYPE, long[].class, long[].class);
        MethodHandle functionHandle = lookup.findStatic(LambdaizerTest.class, "biInplaceSecond", methodTypeFunction);
        Inplaces.Arity2_2 dynamicFunction = (Inplaces.Arity2_2)Lambdas.lambdaize(Inplaces.Arity2_2.class, (MethodHandle)functionHandle);
        long[] io = new long[]{1L, 2L, 3L};
        long[] i2 = new long[]{3L, 6L, 9L};
        long[] expected = new long[]{4L, 8L, 12L};
        dynamicFunction.mutate((Object)io, (Object)i2);
        for (int i = 0; i < io.length; ++i) {
            assert (i2[i] == expected[i]);
        }
    }
}

