/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.scijava.function.Computers;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.Ops;
import org.scijava.ops.api.RichOp;
import org.scijava.ops.engine.InfoTreeGenerator;
import org.scijava.ops.engine.matcher.convert.ConvertedOpInfo;
import org.scijava.types.Nil;

public class ConvertedInfoTreeGenerator
implements InfoTreeGenerator {
    private static final Nil<Function<?, ?>> FUNCTION_NIL = new Nil<Function<?, ?>>(){};
    private static final Nil<Computers.Arity1<?, ?>> COMPUTER_NIL = new Nil<Computers.Arity1<?, ?>>(){};

    @Override
    public InfoTree generate(OpEnvironment env, String signature, Map<String, OpInfo> idMap, Collection<InfoTreeGenerator> generators) {
        String originalComponent;
        List<String> components = this.parseComponents(signature.substring("|Conversion:".length()));
        Hints dependencyHints = new Hints(new String[]{"history.IGNORE"});
        ArrayList preconverters = new ArrayList();
        int numPreconverters = components.size() - 3;
        for (int i = 0; i < numPreconverters; ++i) {
            String preconverterComp = components.remove(0);
            if (!preconverterComp.startsWith("|Preconverter:")) {
                throw new IllegalArgumentException("Signature " + signature + " does not contain a preconverter signature (starting with |Preconverter:)");
            }
            String preconverterSignature = preconverterComp.substring("|Preconverter:".length());
            InfoTree preconverterTree = InfoTreeGenerator.generateDependencyTree(env, preconverterSignature, idMap, generators);
            preconverters.add(Ops.rich((Object)((Function)env.opFromInfoTree(preconverterTree, FUNCTION_NIL, dependencyHints))));
        }
        String postconverterComp = components.remove(0);
        if (!postconverterComp.startsWith("|Postconverter:")) {
            throw new IllegalArgumentException("Signature " + signature + " does not contain a postconverter signature (starting with |Postconverter:)");
        }
        String postconverterSignature = postconverterComp.substring("|Postconverter:".length());
        InfoTree postconverterTree = InfoTreeGenerator.generateDependencyTree(env, postconverterSignature, idMap, generators);
        RichOp postconverter = Ops.rich((Object)((Function)env.opFromInfoTree(postconverterTree, FUNCTION_NIL, dependencyHints)));
        RichOp copier = null;
        String outCopyComp = components.remove(0);
        if (!outCopyComp.startsWith("|OutputCopier:")) {
            throw new IllegalArgumentException("Signature " + signature + " does not contain a copier signature (starting with |OutputCopier:)");
        }
        String outCopySignature = outCopyComp.substring("|OutputCopier:".length());
        if (!outCopySignature.isEmpty()) {
            InfoTree copierTree = InfoTreeGenerator.generateDependencyTree(env, outCopySignature, idMap, generators);
            copier = Ops.rich((Object)((Computers.Arity1)env.opFromInfoTree(copierTree, COMPUTER_NIL, dependencyHints)));
        }
        if (!(originalComponent = components.remove(0)).startsWith("|OriginalInfo:")) {
            throw new IllegalArgumentException("Signature " + signature + " does not contain an original Op signature (starting with |OriginalInfo:)");
        }
        String originalSignature = originalComponent.substring("|OriginalInfo:".length());
        InfoTree originalTree = InfoTreeGenerator.generateDependencyTree(env, originalSignature, idMap, generators);
        ConvertedOpInfo baseInfo = new ConvertedOpInfo(originalTree.info(), preconverters, postconverter, copier, env);
        return new InfoTree((OpInfo)baseInfo, originalTree.dependencies());
    }

    private List<String> parseComponents(String signature) {
        ArrayList<String> components = new ArrayList<String>();
        String s = signature;
        while (!s.isEmpty()) {
            String subSignatureFrom = InfoTreeGenerator.subSignatureFrom(s, 0);
            components.add(subSignatureFrom);
            s = s.substring(subSignatureFrom.length());
        }
        return components;
    }

    @Override
    public boolean canGenerate(String signature) {
        return signature.startsWith("|Conversion:");
    }
}

