/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.impl;

import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInstance;
import org.scijava.ops.api.RichOp;
import org.scijava.ops.engine.MatchingConditions;
import org.scijava.progress.Progress;

public abstract class AbstractRichOp<T>
implements RichOp<T> {
    private final OpInstance<T> instance;
    private final OpEnvironment env;
    private final MatchingConditions conditions;
    public boolean record = true;

    public AbstractRichOp(OpInstance<T> instance, OpEnvironment env, MatchingConditions conditions) {
        this.instance = instance;
        this.env = env;
        this.conditions = conditions;
    }

    public OpEnvironment env() {
        return this.env;
    }

    public Hints hints() {
        return this.conditions.hints();
    }

    public String name() {
        return this.conditions.request().name();
    }

    public OpInstance<T> instance() {
        return this.instance;
    }

    public void preprocess(Object ... inputs) {
        if (this.hints().contains("progress.TRACK")) {
            Progress.register((Object)this, (String)this.conditions.request().name());
        } else {
            Progress.ignore();
        }
    }

    public void postprocess(Object output) {
        if (!this.hints().contains("history.IGNORE")) {
            this.env.history().logOutput((RichOp)this, output);
        }
        Progress.complete();
    }

    public String toString() {
        return this.instance().toString();
    }
}

