/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.util;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.scijava.common3.Classes;

public final class Lambdas {
    private Lambdas() {
    }

    public static <T> T lambdaize(Class<T> functionalInterface, MethodHandle methodHandle) throws Throwable {
        return Lambdas.lambdaize(functionalInterface, methodHandle, new Class[0], new Object[0]);
    }

    public static <T> T lambdaize(Class<T> functionalInterface, MethodHandle methodHandle, Class<?>[] capturedClasses, Object[] capturedArgs) throws Throwable {
        MethodHandles.Lookup caller = MethodHandles.lookup();
        String[] invokedNames = (String[])Arrays.stream(functionalInterface.getDeclaredMethods()).filter(method -> Modifier.isAbstract(method.getModifiers())).map(Method::getName).toArray(String[]::new);
        if (invokedNames.length != 1) {
            throw new IllegalArgumentException("The passed class is not a functional interface");
        }
        MethodType invokedType = MethodType.methodType(functionalInterface, capturedClasses);
        MethodType methodType = methodHandle.type();
        methodType = methodType.dropParameterTypes(0, capturedArgs.length);
        for (int i = 0; i < methodType.parameterCount(); ++i) {
            TypeDescriptor.OfField paramType = methodType.parameterType(i);
            if (!((Class)paramType).isPrimitive()) continue;
            methodType = methodType.changeParameterType(i, Classes.box((Class)paramType));
        }
        TypeDescriptor.OfField rType = methodType.returnType();
        if (((Class)rType).isPrimitive() && rType != Void.TYPE) {
            rType = Classes.box((Class)rType);
        }
        MethodType samMethodType = methodType.generic().changeReturnType((Class<?>)(rType == Void.TYPE ? rType : Object.class));
        MethodHandle callSite = LambdaMetafactory.metafactory(caller, invokedNames[0], invokedType, samMethodType, methodHandle, methodType).getTarget();
        return (T)callSite.invokeWithArguments(capturedArgs);
    }
}

