/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.yaml.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.scijava.common3.Classes;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.FunctionalParameters;
import org.scijava.ops.engine.struct.SynthesizedParameterMember;
import org.scijava.ops.engine.util.Infos;
import org.scijava.ops.engine.yaml.impl.AbstractYAMLOpInfo;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;

public class YAMLOpFieldInfo
extends AbstractYAMLOpInfo {
    private final Object instance;
    private final Field field;
    private final Struct struct;

    public YAMLOpFieldInfo(Map<String, Object> yaml, String identifier) throws Exception {
        super(yaml, identifier);
        int clsIndex = identifier.indexOf(36);
        String clsString = identifier.substring(0, clsIndex);
        Class cls = Classes.load((String)clsString);
        this.instance = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        String fieldString = identifier.substring(clsIndex + 1);
        this.field = cls.getDeclaredField(fieldString);
        this.struct = this.createStruct(yaml);
        Infos.validate(this);
    }

    public Type opType() {
        return this.field.getGenericType();
    }

    @Override
    public Struct struct() {
        return this.struct;
    }

    public String implementationName() {
        Object fullyQualifiedField = this.field.toGenericString();
        int lastDotPos = ((String)fullyQualifiedField).lastIndexOf(46);
        fullyQualifiedField = ((String)fullyQualifiedField).substring(0, lastDotPos) + "$" + ((String)fullyQualifiedField).substring(lastDotPos + 1);
        String packageName = this.field.getDeclaringClass().getPackageName();
        int classNameIndex = ((String)fullyQualifiedField).lastIndexOf(packageName);
        return ((String)fullyQualifiedField).substring(classNameIndex);
    }

    public AnnotatedElement getAnnotationBearer() {
        return this.field;
    }

    public String id() {
        return "|Info:" + this.implementationName() + "@" + this.version();
    }

    private Struct createStruct(Map<String, Object> yaml) {
        ArrayList members = new ArrayList();
        List params = (List)yaml.get("parameters");
        List<FunctionalMethodType> fmts = FunctionalParameters.findFunctionalMethodTypes(this.opType());
        for (int i = 0; i < params.size(); ++i) {
            Map pMap = (Map)params.get(i);
            FunctionalMethodType fmt = fmts.get(i);
            String name = (String)pMap.get("name");
            String description = (String)pMap.get("description");
            boolean nullable = pMap.getOrDefault("nullable", false);
            members.add(new SynthesizedParameterMember(fmt, name, !nullable, description));
        }
        return () -> members;
    }

    public StructInstance<?> createOpInstance(List<?> dependencies) {
        if (dependencies != null && !dependencies.isEmpty()) {
            throw new IllegalArgumentException("Op fields are not allowed to have any Op dependencies.");
        }
        try {
            Object object = this.field.get(this.instance);
            return this.struct().createInstance(object);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException(exc);
        }
    }
}

