/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.JavaCheckMessage;
import org.sonar.java.SonarComponents;
import org.sonar.plugins.java.CompIssue;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;

public class ChecksBridge {
    private final Iterable<Checks<JavaCheck>> checks;
    private final ResourcePerspectives resourcePerspectives;
    private final FileSystem fs;

    public ChecksBridge(SonarComponents sonarComponents) {
        this.checks = sonarComponents.checks();
        this.resourcePerspectives = sonarComponents.getResourcePerspectives();
        this.fs = sonarComponents.getFileSystem();
    }

    public void reportIssues(SourceFile squidFile, Resource sonarFile) {
        if (squidFile.hasCheckMessages()) {
            Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, sonarFile);
            Set messages = squidFile.getCheckMessages();
            if (issuable != null) {
                for (CheckMessage checkMessage : messages) {
                    AnalyzerMessage issue;
                    Object check = checkMessage.getCheck();
                    RuleKey ruleKey = this.getRuleKey((JavaCheck)check);
                    if (ruleKey == null) {
                        throw new IllegalStateException("Cannot find rule key for instance of " + check.getClass());
                    }
                    if (checkMessage instanceof JavaCheckMessage && (issue = ((JavaCheckMessage)checkMessage).getAnalyzerMessage()) != null) {
                        this.reportIssueNew(sonarFile, issuable, issue, ruleKey);
                        continue;
                    }
                    issue = issuable.newIssueBuilder().ruleKey(ruleKey).line(checkMessage.getLine()).message(checkMessage.formatDefaultMessage()).effortToFix(checkMessage.getCost()).build();
                    issuable.addIssue((Issue)issue);
                }
            }
            messages.clear();
        }
    }

    private void reportIssueNew(Resource sonarFile, Issuable issuable, AnalyzerMessage issue, RuleKey ruleKey) {
        InputFile inputFile = this.fs.inputFile(this.fs.predicates().hasPath(sonarFile.getPath()));
        CompIssue compIssue = CompIssue.create(inputFile, issuable, ruleKey, issue.getCost());
        AnalyzerMessage.TextSpan textSpan = issue.primaryLocation();
        if (textSpan == null) {
            compIssue.setPrimaryLocation(issue.getMessage(), null);
        } else {
            compIssue.setPrimaryLocation(issue.getMessage(), textSpan.startLine, textSpan.startCharacter, textSpan.endLine, textSpan.endCharacter);
        }
        for (AnalyzerMessage secondaryLocation : issue.secondaryLocations) {
            AnalyzerMessage.TextSpan secondarySpan = secondaryLocation.primaryLocation();
            compIssue.addSecondaryLocation(secondarySpan.startLine, secondarySpan.startCharacter, secondarySpan.endLine, secondarySpan.endCharacter, secondaryLocation.getMessage());
        }
        compIssue.save();
    }

    @CheckForNull
    private RuleKey getRuleKey(JavaCheck check) {
        for (Checks<JavaCheck> sonarChecks : this.checks) {
            RuleKey ruleKey = sonarChecks.ruleKey((Object)check);
            if (ruleKey == null) continue;
            return ruleKey;
        }
        return null;
    }
}

