/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.javascript;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.PostJob;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Project;

public class TypeStatistics
implements PostJob {
    private static final Logger LOG = LoggerFactory.getLogger(TypeStatistics.class);
    private static int totalSymbol = 0;
    private static int totalTypes = 0;
    private static int totalUnknownType = 0;
    private static int totalSymbolsWithType = 0;

    public static void increaseSymbol(int numberOfTypes) {
        ++totalSymbol;
        totalTypes += numberOfTypes;
        if (numberOfTypes > 0) {
            ++totalSymbolsWithType;
        }
    }

    public void executeOn(Project project, SensorContext sensorContext) {
        LOG.info("");
        LOG.info("============  SYMBOL TYPE STATISTICS  =============");
        LOG.info("\t\t Total Symbols:.........................{}", (Object)totalSymbol);
        LOG.info("");
        LOG.info("\t\t Total Symbol with Types:...............{}", (Object)totalSymbolsWithType);
        LOG.info("\t\t Symbol with Types:.....................{} %", (Object)Math.round((double)totalSymbolsWithType / (double)totalSymbol * 100.0));
        LOG.info("\t\t\t Total Symbol without UNKNOWN:........{}", (Object)(totalSymbolsWithType - totalUnknownType));
        LOG.info("\t\t\t Total UNKNOWN:.......................{}", (Object)totalUnknownType);
        LOG.info("");
        LOG.info("\t\t Average number of types:...............{}", (Object)((double)totalTypes / (double)totalSymbolsWithType));
        LOG.info("");
    }

    public static void increaseUnknown() {
        ++totalUnknownType;
    }
}

