/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.PythonChecks;
import org.sonar.plugins.python.PythonHighlighter;
import org.sonar.plugins.python.SonarQubePythonFile;
import org.sonar.plugins.python.SymbolVisitor;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.cpd.PythonCpdAnalyzer;
import org.sonar.python.SubscriptionVisitor;
import org.sonar.python.metrics.FileLinesVisitor;
import org.sonar.python.metrics.FileMetrics;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.PythonTreeMaker;

public class PythonScanner {
    private static final Logger LOG = Loggers.get(PythonScanner.class);
    private final SensorContext context;
    private final PythonParser parser;
    private final List<InputFile> inputFiles;
    private final Map<InputFile, String> packageNames = new HashMap<InputFile, String>();
    private final PythonChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final PythonCpdAnalyzer cpdAnalyzer;

    public PythonScanner(SensorContext context, PythonChecks checks, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, List<InputFile> inputFiles) {
        this.context = context;
        this.checks = checks;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.cpdAnalyzer = new PythonCpdAnalyzer(context);
        this.inputFiles = inputFiles;
        this.parser = PythonParser.create();
    }

    public void scanFiles() {
        Map<String, Set<Symbol>> globalSymbolsByModuleName = this.globalSymbolsByModuleName();
        for (InputFile pythonFile : this.inputFiles) {
            if (this.context.isCancelled()) {
                return;
            }
            try {
                this.scanFile(pythonFile, globalSymbolsByModuleName);
            }
            catch (Exception e) {
                LOG.warn("Unable to analyze file '{}'. Error: {}", (Object)pythonFile.toString(), (Object)e);
            }
        }
    }

    private Map<String, Set<Symbol>> globalSymbolsByModuleName() {
        HashMap<String, Set<Symbol>> globalSymbols = new HashMap<String, Set<Symbol>>();
        for (InputFile inputFile : this.inputFiles) {
            if (this.context.isCancelled()) {
                return globalSymbols;
            }
            try {
                AstNode astNode = this.parser.parse(inputFile.contents());
                FileInput astRoot = new PythonTreeMaker().fileInput(astNode);
                String packageName = SymbolUtils.pythonPackageName(inputFile.file(), this.context.fileSystem().baseDir());
                this.packageNames.put(inputFile, packageName);
                String fullyQualifiedModuleName = SymbolUtils.fullyQualifiedModuleName(packageName, inputFile.filename());
                PythonFile pythonFile = SonarQubePythonFile.create(inputFile);
                globalSymbols.put(fullyQualifiedModuleName, SymbolUtils.globalSymbols(astRoot, fullyQualifiedModuleName, pythonFile));
            }
            catch (Exception e) {
                LOG.debug("Unable to construct project-level symbol table for file: " + inputFile.toString());
                LOG.debug(e.getMessage());
            }
        }
        return globalSymbols;
    }

    private void scanFile(InputFile inputFile, Map<String, Set<Symbol>> globalSymbols) {
        PythonVisitorContext visitorContext;
        PythonFile pythonFile = SonarQubePythonFile.create(inputFile);
        try {
            AstNode astNode = this.parser.parse(pythonFile.content());
            FileInput parse = new PythonTreeMaker().fileInput(astNode);
            visitorContext = new PythonVisitorContext(parse, pythonFile, this.context.fileSystem().workDir(), this.packageNames.get(inputFile), globalSymbols);
            this.saveMeasures(inputFile, visitorContext);
        }
        catch (RecognitionException e) {
            visitorContext = new PythonVisitorContext(pythonFile, e);
            LOG.error("Unable to parse file: " + inputFile.toString());
            LOG.error(e.getMessage());
            this.context.newAnalysisError().onFile(inputFile).at(inputFile.newPointer(e.getLine(), 0)).message(e.getMessage()).save();
        }
        ArrayList<PythonSubscriptionCheck> checksBasedOnTree = new ArrayList<PythonSubscriptionCheck>();
        for (PythonCheck check : this.checks.all()) {
            if (check instanceof PythonSubscriptionCheck) {
                checksBasedOnTree.add((PythonSubscriptionCheck)check);
                continue;
            }
            check.scanFile(visitorContext);
        }
        SubscriptionVisitor.analyze(checksBasedOnTree, visitorContext);
        this.saveIssues(inputFile, visitorContext.getIssues());
        if (visitorContext.rootTree() != null) {
            new SymbolVisitor(this.context.newSymbolTable().onFile(inputFile)).visitFileInput(visitorContext.rootTree());
            new PythonHighlighter(this.context, inputFile).scanFile(visitorContext);
        }
    }

    private void saveIssues(InputFile inputFile, List<PythonCheck.PreciseIssue> issues) {
        for (PythonCheck.PreciseIssue preciseIssue : issues) {
            RuleKey ruleKey = this.checks.ruleKey(preciseIssue.check());
            NewIssue newIssue = this.context.newIssue().forRule(ruleKey);
            Integer cost = preciseIssue.cost();
            if (cost != null) {
                newIssue.gap(Double.valueOf(cost.doubleValue()));
            }
            NewIssueLocation primaryLocation = PythonScanner.newLocation(inputFile, newIssue, preciseIssue.primaryLocation());
            newIssue.at(primaryLocation);
            ArrayDeque<NewIssueLocation> secondaryLocationsFlow = new ArrayDeque<NewIssueLocation>();
            for (IssueLocation secondaryLocation : preciseIssue.secondaryLocations()) {
                String fileId = secondaryLocation.fileId();
                if (fileId != null) {
                    InputFile issueLocationFile = PythonScanner.component(fileId, this.context);
                    if (issueLocationFile == null) continue;
                    secondaryLocationsFlow.addFirst(PythonScanner.newLocation(issueLocationFile, newIssue, secondaryLocation));
                    continue;
                }
                newIssue.addLocation(PythonScanner.newLocation(inputFile, newIssue, secondaryLocation));
            }
            if (!secondaryLocationsFlow.isEmpty()) {
                secondaryLocationsFlow.addFirst(primaryLocation);
                newIssue.addFlow(secondaryLocationsFlow);
            }
            newIssue.save();
        }
    }

    @CheckForNull
    private static InputFile component(String fileId, SensorContext sensorContext) {
        InputFile inputFile = sensorContext.fileSystem().inputFile(sensorContext.fileSystem().predicates().is(new File(fileId)));
        if (inputFile == null) {
            LOG.debug("Failed to find InputFile for {}", (Object)fileId);
        }
        return inputFile;
    }

    private static NewIssueLocation newLocation(InputFile inputFile, NewIssue issue, IssueLocation location) {
        String message;
        NewIssueLocation newLocation = issue.newLocation().on((InputComponent)inputFile);
        if (location.startLine() != 0) {
            TextRange range = location.startLineOffset() == -1 ? inputFile.selectLine(location.startLine()) : inputFile.newRange(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset());
            newLocation.at(range);
        }
        if ((message = location.message()) != null) {
            newLocation.message(message);
        }
        return newLocation;
    }

    private void saveMeasures(InputFile inputFile, PythonVisitorContext visitorContext) {
        FileMetrics fileMetrics = new FileMetrics(visitorContext);
        FileLinesVisitor fileLinesVisitor = fileMetrics.fileLinesVisitor();
        this.cpdAnalyzer.pushCpdTokens(inputFile, visitorContext);
        this.noSonarFilter.noSonarInFile(inputFile, fileLinesVisitor.getLinesWithNoSonar());
        Set<Integer> linesOfCode = fileLinesVisitor.getLinesOfCode();
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.NCLOC, linesOfCode.size());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.STATEMENTS, fileMetrics.numberOfStatements());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.FUNCTIONS, fileMetrics.numberOfFunctions());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.CLASSES, fileMetrics.numberOfClasses());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COMPLEXITY, fileMetrics.complexity());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COGNITIVE_COMPLEXITY, fileMetrics.cognitiveComplexity());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COMMENT_LINES, fileLinesVisitor.getCommentLineCount());
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile);
        for (int line : linesOfCode) {
            fileLinesContext.setIntValue("ncloc_data", line, 1);
        }
        for (int line : fileLinesVisitor.getExecutableLines()) {
            fileLinesContext.setIntValue("executable_lines_data", line, 1);
        }
        fileLinesContext.save();
    }

    private void saveMetricOnFile(InputFile inputFile, Metric<Integer> metric, Integer value) {
        this.context.newMeasure().withValue((Serializable)value).forMetric(metric).on((InputComponent)inputFile).save();
    }
}

