/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.bandit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.bandit.BanditJsonReportReader;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class BanditSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(BanditSensor.class);
    public static final String LINTER_NAME = "Bandit";
    public static final String LINTER_KEY = "bandit";
    public static final String REPORT_PATH_KEY = "sonar.python.bandit.reportPaths";
    private static final Long DEFAULT_CONSTANT_DEBT_MINUTES = 5L;
    private static final int MAX_LOGGED_FILE_NAMES = 20;

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyWhenConfiguration(conf -> conf.hasKey(REPORT_PATH_KEY)).onlyOnLanguage("py").name("Import of Bandit issues");
    }

    public void execute(SensorContext context) {
        HashSet<String> unresolvedInputFiles = new HashSet<String>();
        List<File> reportFiles = ExternalReportProvider.getReportFiles(context, REPORT_PATH_KEY);
        reportFiles.forEach(report -> BanditSensor.importReport(report, context, unresolvedInputFiles));
        BanditSensor.logUnresolvedInputFiles(unresolvedInputFiles);
    }

    private static void logUnresolvedInputFiles(Set<String> unresolvedInputFiles) {
        if (unresolvedInputFiles.isEmpty()) {
            return;
        }
        String fileList = unresolvedInputFiles.stream().sorted().limit(20L).collect(Collectors.joining(";"));
        if (unresolvedInputFiles.size() > 20) {
            fileList = fileList + ";...";
        }
        LOG.warn("Fail to resolve {} file path(s) in Bandit report. No issues imported related to file(s): {}", (Object)unresolvedInputFiles.size(), (Object)fileList);
    }

    private static void importReport(File reportPath, SensorContext context, Set<String> unresolvedInputFiles) {
        try (FileInputStream in = new FileInputStream(reportPath);){
            LOG.info("Importing {}", (Object)reportPath);
            boolean engineIdIsSupported = context.getSonarQubeVersion().isGreaterThanOrEqual(Version.create((int)7, (int)4));
            BanditJsonReportReader.read(in, issue -> BanditSensor.saveIssue(context, issue, unresolvedInputFiles, engineIdIsSupported));
        }
        catch (IOException | RuntimeException | ParseException e) {
            LOG.error("No issues information will be saved as the report file '{}' can't be read. " + e.getClass().getSimpleName() + ": " + e.getMessage(), (Object)reportPath, (Object)e);
        }
    }

    private static void saveIssue(SensorContext context, BanditJsonReportReader.Issue issue, Set<String> unresolvedInputFiles, boolean engineIdIsSupported) {
        if (StringUtils.isEmpty(issue.ruleKey) || StringUtils.isEmpty(issue.filePath) || StringUtils.isEmpty(issue.message)) {
            LOG.debug("Missing information for ruleKey:'{}', filePath:'{}', message:'{}'", new Object[]{issue.ruleKey, issue.filePath, issue.message});
            return;
        }
        InputFile inputFile = context.fileSystem().inputFile(context.fileSystem().predicates().hasPath(issue.filePath));
        if (inputFile == null) {
            unresolvedInputFiles.add(issue.filePath);
            return;
        }
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        newExternalIssue.type(RuleType.VULNERABILITY).severity(BanditSensor.toSonarQubeSeverity(issue.severity, issue.confidence)).remediationEffortMinutes(DEFAULT_CONSTANT_DEBT_MINUTES);
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(issue.message).on((InputComponent)inputFile);
        if (issue.lineNumber != null) {
            primaryLocation.at(inputFile.selectLine(issue.lineNumber.intValue()));
        }
        newExternalIssue.at(primaryLocation);
        if (engineIdIsSupported) {
            newExternalIssue.engineId(LINTER_KEY).ruleId(issue.ruleKey);
        } else {
            newExternalIssue.forRule(RuleKey.of((String)LINTER_KEY, (String)issue.ruleKey));
        }
        newExternalIssue.save();
    }

    private static Severity toSonarQubeSeverity(String severity, String confidence) {
        if ("HIGH".equalsIgnoreCase(severity)) {
            return "HIGH".equalsIgnoreCase(confidence) ? Severity.BLOCKER : Severity.CRITICAL;
        }
        if ("MEDIUM".equalsIgnoreCase(severity)) {
            return Severity.MAJOR;
        }
        return Severity.MINOR;
    }
}

