/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="LongIntegerWithLowercaseSuffixUsage")
public class LongIntegerWithLowercaseSuffixUsageCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "LongIntegerWithLowercaseSuffixUsage";
    private static final String MESSAGE = "Replace suffix in long integers from lower case \"l\" to upper case \"L\".";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.NUMERIC_LITERAL, ctx -> {
            NumericLiteral pyNumericLiteralTree = (NumericLiteral)ctx.syntaxNode();
            String value = pyNumericLiteralTree.valueAsString();
            if (value.charAt(value.length() - 1) == 'l') {
                ctx.addIssue(pyNumericLiteralTree, MESSAGE);
            }
        });
    }
}

