/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.PythonCfgBranchingBlock;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S3626")
public class RedundantJumpCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> RedundantJumpCheck.checkCfg(ControlFlowGraph.build((FileInput)ctx.syntaxNode(), ctx.pythonFile()), ctx));
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> RedundantJumpCheck.checkCfg(ControlFlowGraph.build((FunctionDef)ctx.syntaxNode(), ctx.pythonFile()), ctx));
    }

    private static void checkCfg(@Nullable ControlFlowGraph cfg, SubscriptionContext ctx) {
        if (cfg == null) {
            return;
        }
        for (CfgBlock cfgBlock : cfg.blocks()) {
            List<Tree> elements;
            Tree lastElement;
            if (cfgBlock.successors().size() != 1 || !cfgBlock.successors().contains(cfgBlock.syntacticSuccessor()) || RedundantJumpCheck.isException(lastElement = (elements = cfgBlock.elements()).get(elements.size() - 1))) continue;
            PythonCheck.PreciseIssue preciseIssue = ctx.addIssue(lastElement, RedundantJumpCheck.message(lastElement));
            if (!lastElement.is(Tree.Kind.CONTINUE_STMT)) continue;
            Tree loop = ((PythonCfgBranchingBlock)cfgBlock.successors().iterator().next()).branchingTree();
            preciseIssue.secondary(loop.firstToken(), null);
        }
    }

    private static String message(Tree jumpStatement) {
        String jumpKind = jumpStatement.is(Tree.Kind.RETURN_STMT) ? "return" : "continue";
        return "Remove this redundant " + jumpKind + ".";
    }

    private static boolean isInsideSingleStatementBlock(Tree lastElement) {
        StatementList block = (StatementList)lastElement.parent();
        return block.statements().size() == 1;
    }

    private static boolean isReturnWithExpression(Tree lastElement) {
        return lastElement.is(Tree.Kind.RETURN_STMT) && !((ReturnStatement)lastElement).expressions().isEmpty();
    }

    private static boolean isException(Tree lastElement) {
        return lastElement.is(Tree.Kind.RAISE_STMT) || RedundantJumpCheck.isReturnWithExpression(lastElement) || RedundantJumpCheck.isInsideSingleStatementBlock(lastElement) || RedundantJumpCheck.hasTryAncestor(lastElement);
    }

    private static boolean hasTryAncestor(Tree element) {
        return TreeUtils.firstAncestorOfKind(element, Tree.Kind.TRY_STMT) != null;
    }
}

