/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.parser;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.LexerState;
import org.sonar.python.lexer.PythonLexer;

public final class PythonParser {
    private final Parser<Grammar> sslrParser = new SslrPythonParser();

    public static PythonParser create() {
        return new PythonParser();
    }

    private PythonParser() {
    }

    public AstNode parse(String source) {
        return this.sslrParser.parse(source);
    }

    public void setRootRule(Rule rule) {
        this.sslrParser.setRootRule(rule);
    }

    public Grammar getGrammar() {
        return this.sslrParser.getGrammar();
    }

    public RuleDefinition getRootRule() {
        return this.sslrParser.getRootRule();
    }

    private static class SslrPythonParser
    extends Parser<Grammar> {
        private final LexerState lexerState;
        private final Lexer lexer;

        private SslrPythonParser() {
            super(PythonGrammar.create());
            super.setRootRule(((Grammar)super.getGrammar()).getRootRule());
            this.lexerState = new LexerState();
            this.lexer = PythonLexer.create(StandardCharsets.UTF_8, this.lexerState);
        }

        @Override
        public AstNode parse(String source) {
            this.lexerState.reset();
            this.lexer.lex(source);
            return super.parse(this.tokens());
        }

        private List<Token> tokens() {
            List<Token> tokens = this.lexer.getTokens();
            if (this.lexerState.indentationStack.peek() > 0) {
                Token eofToken = tokens.get(tokens.size() - 1);
                tokens = new ArrayList<Token>(tokens.subList(0, tokens.size() - 1));
                while (this.lexerState.indentationStack.peek() > 0) {
                    this.lexerState.indentationStack.pop();
                    tokens.add(Token.builder().setURI(eofToken.getURI()).setType(PythonTokenType.DEDENT).setLine(eofToken.getLine()).setColumn(eofToken.getColumn()).setValueAndOriginalValue("").build());
                }
                tokens.add(eofToken);
            }
            return tokens;
        }
    }
}

