/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.CompoundAssignmentStatement;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.FunctionLike;
import org.sonar.plugins.python.api.tree.GlobalStatement;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NonlocalStatement;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TupleParameter;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.python.semantic.BuiltinSymbols;
import org.sonar.python.semantic.Scope;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.ClassDefImpl;
import org.sonar.python.tree.ComprehensionExpressionImpl;
import org.sonar.python.tree.DictCompExpressionImpl;
import org.sonar.python.tree.FileInputImpl;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.ImportFromImpl;
import org.sonar.python.tree.LambdaExpressionImpl;

public class SymbolTableBuilder
extends BaseTreeVisitor {
    private String fullyQualifiedModuleName;
    private List<String> filePath;
    private Map<String, Set<Symbol>> globalSymbolsByModuleName;
    private Map<String, Symbol> globalSymbolsByFQN;
    private Map<Tree, Scope> scopesByRootTree;
    private Set<Tree> assignmentLeftHandSides = new HashSet<Tree>();
    private final PythonFile pythonFile;

    public SymbolTableBuilder(PythonFile pythonFile) {
        this.fullyQualifiedModuleName = null;
        this.filePath = null;
        this.globalSymbolsByModuleName = Collections.emptyMap();
        this.globalSymbolsByFQN = Collections.emptyMap();
        this.pythonFile = pythonFile;
    }

    public SymbolTableBuilder(String packageName, PythonFile pythonFile) {
        this(packageName, pythonFile, Collections.emptyMap());
    }

    public SymbolTableBuilder(String packageName, PythonFile pythonFile, Map<String, Set<Symbol>> globalSymbolsByModuleName) {
        this.pythonFile = pythonFile;
        String fileName = pythonFile.fileName();
        int extensionIndex = fileName.lastIndexOf(46);
        String moduleName = extensionIndex > 0 ? fileName.substring(0, extensionIndex) : fileName;
        this.filePath = new ArrayList<String>(Arrays.asList(packageName.split("\\.")));
        this.filePath.add(moduleName);
        this.fullyQualifiedModuleName = SymbolUtils.fullyQualifiedModuleName(packageName, fileName);
        this.globalSymbolsByModuleName = globalSymbolsByModuleName;
        this.globalSymbolsByFQN = globalSymbolsByModuleName.values().stream().flatMap(Collection::stream).filter(symbol -> symbol.fullyQualifiedName() != null).collect(Collectors.toMap(Symbol::fullyQualifiedName, Function.identity()));
    }

    @Override
    public void visitFileInput(FileInput fileInput) {
        this.scopesByRootTree = new HashMap<Tree, Scope>();
        fileInput.accept(new FirstPhaseVisitor());
        fileInput.accept(new SecondPhaseVisitor());
        for (Scope scope : this.scopesByRootTree.values()) {
            if (scope.rootTree instanceof FunctionLike) {
                FunctionLike funcDef = (FunctionLike)scope.rootTree;
                for (Symbol symbol : scope.symbols()) {
                    if (funcDef.is(Tree.Kind.LAMBDA)) {
                        ((LambdaExpressionImpl)funcDef).addLocalVariableSymbol(symbol);
                        continue;
                    }
                    ((FunctionDefImpl)funcDef).addLocalVariableSymbol(symbol);
                }
                continue;
            }
            if (scope.rootTree.is(Tree.Kind.CLASSDEF)) {
                ClassDefImpl classDef = (ClassDefImpl)scope.rootTree;
                scope.symbols().forEach(classDef::addClassField);
                scope.instanceAttributesByName.values().forEach(classDef::addInstanceField);
                continue;
            }
            if (scope.rootTree.is(Tree.Kind.FILE_INPUT)) {
                scope.symbols().stream().filter(s -> !scope.builtinSymbols.contains(s)).forEach(((FileInputImpl)fileInput)::addGlobalVariables);
                continue;
            }
            if (scope.rootTree.is(Tree.Kind.DICT_COMPREHENSION)) {
                scope.symbols().forEach(((DictCompExpressionImpl)scope.rootTree)::addLocalVariableSymbol);
                continue;
            }
            if (!(scope.rootTree instanceof ComprehensionExpression)) continue;
            scope.symbols().forEach(((ComprehensionExpressionImpl)scope.rootTree)::addLocalVariableSymbol);
        }
    }

    private class SecondPhaseVisitor
    extends ScopeVisitor {
        private SecondPhaseVisitor() {
        }

        @Override
        public void visitFileInput(FileInput tree) {
            this.enterScope(tree);
            super.visitFileInput(tree);
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            this.scan(pyFunctionDefTree.decorators());
            this.enterScope(pyFunctionDefTree);
            this.scan(pyFunctionDefTree.name());
            this.scan(pyFunctionDefTree.parameters());
            this.scan(pyFunctionDefTree.returnTypeAnnotation());
            this.scan(pyFunctionDefTree.body());
            this.leaveScope();
        }

        @Override
        public void visitParameter(Parameter parameter) {
            Tree currentScopeTree = this.leaveScope();
            this.scan(parameter.defaultValue());
            this.enterScope(currentScopeTree);
            this.scan(parameter.name());
            this.scan(parameter.typeAnnotation());
        }

        @Override
        public void visitLambda(LambdaExpression pyLambdaExpressionTree) {
            this.enterScope(pyLambdaExpressionTree);
            super.visitLambda(pyLambdaExpressionTree);
            this.leaveScope();
        }

        @Override
        public void visitPyListOrSetCompExpression(ComprehensionExpression tree) {
            this.enterScope(tree);
            this.scan(tree.resultExpression());
            ComprehensionFor comprehensionFor = tree.comprehensionFor();
            this.scan(comprehensionFor.loopExpression());
            this.leaveScope();
            this.scan(comprehensionFor.iterable());
            this.enterScope(tree);
            this.scan(comprehensionFor.nestedClause());
            this.leaveScope();
        }

        @Override
        public void visitDictCompExpression(DictCompExpressionImpl tree) {
            this.enterScope(tree);
            this.scan(tree.keyExpression());
            this.scan(tree.valueExpression());
            ComprehensionFor comprehensionFor = tree.comprehensionFor();
            this.scan(comprehensionFor.loopExpression());
            this.leaveScope();
            this.scan(comprehensionFor.iterable());
            this.enterScope(tree);
            this.scan(comprehensionFor.nestedClause());
            this.leaveScope();
        }

        @Override
        public void visitClassDef(ClassDef pyClassDefTree) {
            this.scan(pyClassDefTree.args());
            this.scan(pyClassDefTree.decorators());
            this.enterScope(pyClassDefTree);
            this.scan(pyClassDefTree.name());
            this.scan(pyClassDefTree.body());
            SymbolUtils.resolveTypeHierarchy(pyClassDefTree, pyClassDefTree.name().symbol());
            this.leaveScope();
        }

        @Override
        public void visitQualifiedExpression(QualifiedExpression qualifiedExpression) {
            Symbol qualifierSymbol;
            super.visitQualifiedExpression(qualifiedExpression);
            if (qualifiedExpression.qualifier() instanceof HasSymbol && (qualifierSymbol = ((HasSymbol)((Object)qualifiedExpression.qualifier())).symbol()) != null) {
                Usage.Kind usageKind = SymbolTableBuilder.this.assignmentLeftHandSides.contains(qualifiedExpression) ? Usage.Kind.ASSIGNMENT_LHS : Usage.Kind.OTHER;
                ((SymbolImpl)qualifierSymbol).addOrCreateChildUsage(qualifiedExpression.name(), usageKind);
            }
        }

        @Override
        public void visitDecorator(Decorator decorator) {
            Name nameTree = decorator.name().names().get(0);
            this.addSymbolUsage(nameTree);
            super.visitDecorator(decorator);
        }

        @Override
        public void visitName(Name pyNameTree) {
            if (!pyNameTree.isVariable()) {
                return;
            }
            this.addSymbolUsage(pyNameTree);
            super.visitName(pyNameTree);
        }

        private void addSymbolUsage(Name nameTree) {
            Scope scope = (Scope)SymbolTableBuilder.this.scopesByRootTree.get(this.currentScopeRootTree());
            SymbolImpl symbol = scope.resolve(nameTree.name());
            if (symbol != null && symbol.usages().stream().noneMatch(usage -> usage.tree().equals(nameTree))) {
                symbol.addUsage(nameTree, Usage.Kind.OTHER);
            }
        }
    }

    private class FirstPhaseVisitor
    extends ScopeVisitor {
        private FirstPhaseVisitor() {
        }

        @Override
        public void visitFileInput(FileInput tree) {
            this.createScope(tree, null);
            this.enterScope(tree);
            this.moduleScope = this.currentScope();
            BuiltinSymbols.all().forEach(this.currentScope()::createBuiltinSymbol);
            super.visitFileInput(tree);
        }

        @Override
        public void visitLambda(LambdaExpression pyLambdaExpressionTree) {
            this.createScope(pyLambdaExpressionTree, this.currentScope());
            this.enterScope(pyLambdaExpressionTree);
            this.createParameters(pyLambdaExpressionTree);
            super.visitLambda(pyLambdaExpressionTree);
            this.leaveScope();
        }

        @Override
        public void visitDictCompExpression(DictCompExpressionImpl tree) {
            this.createScope(tree, this.currentScope());
            this.enterScope(tree);
            super.visitDictCompExpression(tree);
            this.leaveScope();
        }

        @Override
        public void visitPyListOrSetCompExpression(ComprehensionExpression tree) {
            this.createScope(tree, this.currentScope());
            this.enterScope(tree);
            super.visitPyListOrSetCompExpression(tree);
            this.leaveScope();
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            String functionName = pyFunctionDefTree.name().name();
            String fullyQualifiedName = this.getFullyQualifiedName(functionName);
            this.currentScope().addFunctionSymbol(pyFunctionDefTree, fullyQualifiedName);
            this.createScope(pyFunctionDefTree, this.currentScope());
            this.enterScope(pyFunctionDefTree);
            this.createParameters(pyFunctionDefTree);
            super.visitFunctionDef(pyFunctionDefTree);
            this.leaveScope();
        }

        @Override
        public void visitClassDef(ClassDef pyClassDefTree) {
            String className = pyClassDefTree.name().name();
            String fullyQualifiedName = this.getFullyQualifiedName(className);
            this.currentScope().addClassSymbol(pyClassDefTree, fullyQualifiedName);
            this.createScope(pyClassDefTree, this.currentScope());
            this.enterScope(pyClassDefTree);
            super.visitClassDef(pyClassDefTree);
            this.leaveScope();
        }

        @CheckForNull
        private String getFullyQualifiedName(String name) {
            String prefix = this.scopeQualifiedName();
            if (prefix != null) {
                return prefix.isEmpty() ? name : prefix + "." + name;
            }
            return null;
        }

        private String scopeQualifiedName() {
            Tree scopeTree = this.currentScopeRootTree();
            if (scopeTree.is(Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF)) {
                Name name = scopeTree.is(Tree.Kind.CLASSDEF) ? ((ClassDef)scopeTree).name() : ((FunctionDef)scopeTree).name();
                return Optional.ofNullable(name.symbol()).map(Symbol::fullyQualifiedName).orElse(name.name());
            }
            return SymbolTableBuilder.this.fullyQualifiedModuleName;
        }

        @Override
        public void visitImportName(ImportName pyImportNameTree) {
            this.createImportedNames(pyImportNameTree.modules(), null, Collections.emptyList());
            super.visitImportName(pyImportNameTree);
        }

        @Override
        public void visitImportFrom(ImportFrom importFrom) {
            String moduleName;
            DottedName moduleTree = importFrom.module();
            String string = moduleName = moduleTree != null ? moduleTree.names().stream().map(Name::name).collect(Collectors.joining(".")) : null;
            if (importFrom.isWildcardImport()) {
                Set importedModuleSymbols = (Set)SymbolTableBuilder.this.globalSymbolsByModuleName.get(moduleName);
                if (importedModuleSymbols != null) {
                    this.currentScope().createSymbolsFromWildcardImport(importedModuleSymbols);
                    ((ImportFromImpl)importFrom).setHasUnresolvedWildcardImport(false);
                } else {
                    ((ImportFromImpl)importFrom).setHasUnresolvedWildcardImport(true);
                }
            } else {
                this.createImportedNames(importFrom.importedNames(), moduleName, importFrom.dottedPrefixForModule());
            }
            super.visitImportFrom(importFrom);
        }

        private void createImportedNames(List<AliasedName> importedNames, @Nullable String fromModuleName, List<Token> dottedPrefix) {
            importedNames.forEach(module -> {
                String fullyQualifiedName;
                Name nameTree = module.dottedName().names().get(0);
                String string = fullyQualifiedName = fromModuleName != null ? fromModuleName + "." + nameTree.name() : nameTree.name();
                if (!dottedPrefix.isEmpty()) {
                    fullyQualifiedName = this.resolveFullyQualifiedNameBasedOnRelativeImport(dottedPrefix, fullyQualifiedName);
                }
                Name alias = module.alias();
                if (fromModuleName != null) {
                    this.currentScope().addImportedSymbol(alias == null ? nameTree : alias, fullyQualifiedName, SymbolTableBuilder.this.globalSymbolsByFQN);
                } else {
                    this.currentScope().addModuleSymbol(alias == null ? nameTree : alias, fullyQualifiedName, SymbolTableBuilder.this.globalSymbolsByModuleName);
                }
            });
        }

        @CheckForNull
        private String resolveFullyQualifiedNameBasedOnRelativeImport(List<Token> dottedPrefix, String moduleName) {
            if (SymbolTableBuilder.this.filePath == null || dottedPrefix.size() > SymbolTableBuilder.this.filePath.size()) {
                return null;
            }
            String resolvedPackageName = String.join((CharSequence)"", SymbolTableBuilder.this.filePath.subList(0, SymbolTableBuilder.this.filePath.size() - dottedPrefix.size()));
            return resolvedPackageName.isEmpty() ? moduleName : resolvedPackageName + "." + moduleName;
        }

        @Override
        public void visitForStatement(ForStatement pyForStatementTree) {
            this.createLoopVariables(pyForStatementTree);
            super.visitForStatement(pyForStatementTree);
        }

        @Override
        public void visitComprehensionFor(ComprehensionFor tree) {
            this.addCompDeclarationParam(tree.loopExpression());
            super.visitComprehensionFor(tree);
        }

        private void addCompDeclarationParam(Tree tree) {
            SymbolUtils.boundNamesFromExpression(tree).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.COMP_DECLARATION));
        }

        private void createLoopVariables(ForStatement loopTree) {
            loopTree.expressions().forEach(expr -> SymbolUtils.boundNamesFromExpression(expr).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.LOOP_DECLARATION)));
        }

        private void createParameters(FunctionLike function) {
            AnyParameter first;
            ParameterList parameterList = function.parameters();
            if (parameterList == null || parameterList.all().isEmpty()) {
                return;
            }
            boolean hasSelf = false;
            if (function.isMethodDefinition() && (first = parameterList.all().get(0)).is(Tree.Kind.PARAMETER)) {
                this.currentScope().createSelfParameter((Parameter)first);
                hasSelf = true;
            }
            parameterList.nonTuple().stream().skip(hasSelf ? 1L : 0L).map(Parameter::name).filter(Objects::nonNull).forEach(param -> this.addBindingUsage((Name)param, Usage.Kind.PARAMETER));
            parameterList.all().stream().filter(param -> param.is(Tree.Kind.TUPLE_PARAMETER)).map(TupleParameter.class::cast).forEach(this::addTupleParamElementsToBindingUsage);
        }

        private void addTupleParamElementsToBindingUsage(TupleParameter param) {
            param.parameters().stream().filter(p -> p.is(Tree.Kind.PARAMETER)).map(p -> ((Parameter)p).name()).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.PARAMETER));
            param.parameters().stream().filter(p -> p.is(Tree.Kind.TUPLE_PARAMETER)).map(TupleParameter.class::cast).forEach(this::addTupleParamElementsToBindingUsage);
        }

        @Override
        public void visitAssignmentStatement(AssignmentStatement pyAssignmentStatementTree) {
            List<Expression> lhs = SymbolUtils.assignmentsLhs(pyAssignmentStatementTree);
            SymbolTableBuilder.this.assignmentLeftHandSides.addAll(lhs);
            lhs.forEach(expression -> SymbolUtils.boundNamesFromExpression(expression).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.ASSIGNMENT_LHS)));
            super.visitAssignmentStatement(pyAssignmentStatementTree);
        }

        @Override
        public void visitAnnotatedAssignment(AnnotatedAssignment annotatedAssignment) {
            if (annotatedAssignment.variable().is(Tree.Kind.NAME)) {
                this.addBindingUsage((Name)annotatedAssignment.variable(), Usage.Kind.ASSIGNMENT_LHS);
            }
            super.visitAnnotatedAssignment(annotatedAssignment);
        }

        @Override
        public void visitCompoundAssignment(CompoundAssignmentStatement pyCompoundAssignmentStatementTree) {
            if (pyCompoundAssignmentStatementTree.lhsExpression().is(Tree.Kind.NAME)) {
                this.addBindingUsage((Name)pyCompoundAssignmentStatementTree.lhsExpression(), Usage.Kind.COMPOUND_ASSIGNMENT_LHS);
            }
            super.visitCompoundAssignment(pyCompoundAssignmentStatementTree);
        }

        @Override
        public void visitGlobalStatement(GlobalStatement pyGlobalStatementTree) {
            pyGlobalStatementTree.variables().forEach(name -> {
                this.currentScope().addGlobalName(name.name());
                this.moduleScope.addBindingUsage((Name)name, Usage.Kind.GLOBAL_DECLARATION, null);
            });
            super.visitGlobalStatement(pyGlobalStatementTree);
        }

        @Override
        public void visitNonlocalStatement(NonlocalStatement pyNonlocalStatementTree) {
            pyNonlocalStatementTree.variables().stream().map(Name::name).forEach(name -> this.currentScope().addNonLocalName((String)name));
            super.visitNonlocalStatement(pyNonlocalStatementTree);
        }

        @Override
        public void visitExceptClause(ExceptClause exceptClause) {
            SymbolUtils.boundNamesFromExpression(exceptClause.exceptionInstance()).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.EXCEPTION_INSTANCE));
            super.visitExceptClause(exceptClause);
        }

        @Override
        public void visitWithItem(WithItem withItem) {
            SymbolUtils.boundNamesFromExpression(withItem.expression()).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.WITH_INSTANCE));
            super.visitWithItem(withItem);
        }

        private void createScope(Tree tree, @Nullable Scope parent) {
            SymbolTableBuilder.this.scopesByRootTree.put(tree, new Scope(parent, tree, SymbolTableBuilder.this.pythonFile));
        }

        private void addBindingUsage(Name nameTree, Usage.Kind usage) {
            this.currentScope().addBindingUsage(nameTree, usage, null);
        }

        private Scope currentScope() {
            return (Scope)SymbolTableBuilder.this.scopesByRootTree.get(this.currentScopeRootTree());
        }
    }

    private static class ScopeVisitor
    extends BaseTreeVisitor {
        private Deque<Tree> scopeRootTrees = new LinkedList<Tree>();
        protected Scope moduleScope;

        private ScopeVisitor() {
        }

        Tree currentScopeRootTree() {
            return this.scopeRootTrees.peek();
        }

        void enterScope(Tree tree) {
            this.scopeRootTrees.push(tree);
        }

        Tree leaveScope() {
            return this.scopeRootTrees.pop();
        }
    }
}

