/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collections;
import java.util.List;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class NumericLiteralImpl
extends PyTree
implements NumericLiteral {
    private final String valueAsString;
    private final Token token;

    NumericLiteralImpl(Token token) {
        this.token = token;
        this.valueAsString = token.value();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.NUMERIC_LITERAL;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitNumericLiteral(this);
    }

    @Override
    public long valueAsLong() {
        String literalValue = this.valueAsString.replace("_", "");
        if (literalValue.startsWith("0b") || literalValue.startsWith("0B")) {
            return Integer.valueOf(literalValue.substring(2), 2).intValue();
        }
        if (this.valueAsString.endsWith("L") || this.valueAsString.endsWith("l")) {
            literalValue = literalValue.substring(0, literalValue.length() - 1);
        }
        return Long.parseLong(literalValue);
    }

    @Override
    public String valueAsString() {
        return this.valueAsString;
    }

    @Override
    public List<Tree> computeChildren() {
        return Collections.singletonList(this.token);
    }
}

