/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class StringLiteralImpl
extends PyTree
implements StringLiteral {
    private final List<StringElement> stringElements;

    StringLiteralImpl(List<StringElement> stringElements) {
        this.stringElements = stringElements;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.STRING_LITERAL;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitStringLiteral(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Collections.unmodifiableList(this.stringElements);
    }

    @Override
    public List<StringElement> stringElements() {
        return this.stringElements;
    }

    @Override
    public String trimmedQuotesValue() {
        return this.stringElements().stream().map(StringElement::trimmedQuotesValue).collect(Collectors.joining());
    }
}

