/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.parser;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.sonar.sslr.internal.matchers.AstCreator;
import org.sonar.sslr.internal.matchers.InputBuffer;
import org.sonar.sslr.internal.matchers.LocatedText;
import org.sonar.sslr.parser.LexerlessGrammar;
import org.sonar.sslr.parser.ParseError;
import org.sonar.sslr.parser.ParseErrorFormatter;
import org.sonar.sslr.parser.ParseRunner;
import org.sonar.sslr.parser.ParsingResult;

public class ParserAdapter<G extends LexerlessGrammar>
extends Parser<G> {
    private final Charset charset;
    private final ParseRunner parseRunner;

    public ParserAdapter(Charset charset, G grammar) {
        super((Grammar)Objects.requireNonNull(grammar, "grammar"));
        this.charset = Objects.requireNonNull(charset, "charset");
        this.parseRunner = new ParseRunner(((Grammar)grammar).getRootRule());
    }

    @Override
    public AstNode parse(String source) {
        LocatedText text = new LocatedText(null, source.toCharArray());
        return this.parse(text);
    }

    @Override
    public AstNode parse(File file) {
        LocatedText text = new LocatedText(file, ParserAdapter.fileToCharArray(file, this.charset));
        return this.parse(text);
    }

    private static char[] fileToCharArray(File file, Charset charset) {
        try {
            return new String(Files.readAllBytes(Paths.get(file.getPath(), new String[0])), charset).toCharArray();
        }
        catch (IOException e) {
            throw new RecognitionException(0, e.getMessage(), e);
        }
    }

    private AstNode parse(LocatedText input) {
        char[] chars = input.toChars();
        ParsingResult result = this.parseRunner.parse(chars);
        if (result.isMatched()) {
            return AstCreator.create(result, input);
        }
        ParseError parseError = result.getParseError();
        InputBuffer inputBuffer = parseError.getInputBuffer();
        int line = inputBuffer.getPosition(parseError.getErrorIndex()).getLine();
        String message = new ParseErrorFormatter().format(parseError);
        throw new RecognitionException(line, message);
    }

    @Override
    public AstNode parse(List<Token> tokens) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RuleDefinition getRootRule() {
        throw new UnsupportedOperationException();
    }
}

